/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.model.core.unread.Unread;
import com.ekoapp.ekosdk.internal.ChannelUnreadEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.ChannelUnreadDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class ChannelUnreadDao_Impl
extends ChannelUnreadDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<ChannelUnreadEntity> __insertAdapterOfChannelUnreadEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<ChannelUnreadEntity> __deleteAdapterOfChannelUnreadEntity;
    private final EntityDeleteOrUpdateAdapter<ChannelUnreadEntity> __updateAdapterOfChannelUnreadEntity;

    public ChannelUnreadDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfChannelUnreadEntity = new EntityInsertAdapter<ChannelUnreadEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `channel_unread` (`channelId`,`unreadCount`,`isMentioned`,`readToSegment`,`lastSegment`,`lastMentionedSegment`,`isDeleted`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChannelUnreadEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
                statement.bindLong(2, (long)entity.getUnreadCount());
                int _tmp = entity.isMentioned() ? 1 : 0;
                statement.bindLong(3, (long)_tmp);
                if (entity.getReadToSegment() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindLong(4, (long)entity.getReadToSegment().intValue());
                }
                statement.bindLong(5, (long)entity.getLastSegment());
                if (entity.getLastMentionedSegment() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindLong(6, (long)entity.getLastMentionedSegment().intValue());
                }
                int _tmp_1 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(7, (long)_tmp_1);
                String _tmp_2 = ChannelUnreadDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_2);
                }
                String _tmp_3 = ChannelUnreadDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_3);
                }
                String _tmp_4 = ChannelUnreadDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_4);
                }
            }
        };
        this.__deleteAdapterOfChannelUnreadEntity = new EntityDeleteOrUpdateAdapter<ChannelUnreadEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `channel_unread` WHERE `channelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChannelUnreadEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
            }
        };
        this.__updateAdapterOfChannelUnreadEntity = new EntityDeleteOrUpdateAdapter<ChannelUnreadEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `channel_unread` SET `channelId` = ?,`unreadCount` = ?,`isMentioned` = ?,`readToSegment` = ?,`lastSegment` = ?,`lastMentionedSegment` = ?,`isDeleted` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `channelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChannelUnreadEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
                statement.bindLong(2, (long)entity.getUnreadCount());
                int _tmp = entity.isMentioned() ? 1 : 0;
                statement.bindLong(3, (long)_tmp);
                if (entity.getReadToSegment() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindLong(4, (long)entity.getReadToSegment().intValue());
                }
                statement.bindLong(5, (long)entity.getLastSegment());
                if (entity.getLastMentionedSegment() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindLong(6, (long)entity.getLastMentionedSegment().intValue());
                }
                int _tmp_1 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(7, (long)_tmp_1);
                String _tmp_2 = ChannelUnreadDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_2);
                }
                String _tmp_3 = ChannelUnreadDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_3);
                }
                String _tmp_4 = ChannelUnreadDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_4);
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, entity.getChannelId());
                }
            }
        };
    }

    @Override
    public void insertImpl(ChannelUnreadEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfChannelUnreadEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends ChannelUnreadEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfChannelUnreadEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(ChannelUnreadEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfChannelUnreadEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends ChannelUnreadEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfChannelUnreadEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(ChannelUnreadEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfChannelUnreadEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(ChannelUnreadEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            ChannelUnreadDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends ChannelUnreadEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            ChannelUnreadDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(ChannelUnreadEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            ChannelUnreadDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<ChannelUnreadEntity> getById(String channelId) {
        String _sql = "SELECT * from channel_unread where channelId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel_unread"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from channel_unread where channelId = ? LIMIT 1");){
                ChannelUnreadEntity _result;
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUnreadCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"unreadCount");
                int _columnIndexOfIsMentioned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMentioned");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readToSegment");
                int _columnIndexOfLastSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastSegment");
                int _columnIndexOfLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastMentionedSegment");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new ChannelUnreadEntity();
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    int _tmpUnreadCount = (int)_stmt.getLong(_columnIndexOfUnreadCount);
                    _result.setUnreadCount(_tmpUnreadCount);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsMentioned);
                    boolean _tmpIsMentioned = _tmp != 0;
                    _result.setMentioned(_tmpIsMentioned);
                    Integer _tmpReadToSegment = _stmt.isNull(_columnIndexOfReadToSegment) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfReadToSegment));
                    _result.setReadToSegment(_tmpReadToSegment);
                    int _tmpLastSegment = (int)_stmt.getLong(_columnIndexOfLastSegment);
                    _result.setLastSegment(_tmpLastSegment);
                    Integer _tmpLastMentionedSegment = _stmt.isNull(_columnIndexOfLastMentionedSegment) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfLastMentionedSegment));
                    _result.setLastMentionedSegment(_tmpLastMentionedSegment);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                ChannelUnreadEntity channelUnreadEntity = _result;
                return channelUnreadEntity;
            }
        });
    }

    @Override
    public ChannelUnreadEntity getByChannelIdNow(String channelId) {
        String _sql = "SELECT * from channel_unread where channelId = ? LIMIT 1";
        return (ChannelUnreadEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from channel_unread where channelId = ? LIMIT 1");){
                ChannelUnreadEntity _result;
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUnreadCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"unreadCount");
                int _columnIndexOfIsMentioned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMentioned");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readToSegment");
                int _columnIndexOfLastSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastSegment");
                int _columnIndexOfLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastMentionedSegment");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new ChannelUnreadEntity();
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    int _tmpUnreadCount = (int)_stmt.getLong(_columnIndexOfUnreadCount);
                    _result.setUnreadCount(_tmpUnreadCount);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsMentioned);
                    boolean _tmpIsMentioned = _tmp != 0;
                    _result.setMentioned(_tmpIsMentioned);
                    Integer _tmpReadToSegment = _stmt.isNull(_columnIndexOfReadToSegment) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfReadToSegment));
                    _result.setReadToSegment(_tmpReadToSegment);
                    int _tmpLastSegment = (int)_stmt.getLong(_columnIndexOfLastSegment);
                    _result.setLastSegment(_tmpLastSegment);
                    Integer _tmpLastMentionedSegment = _stmt.isNull(_columnIndexOfLastMentionedSegment) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfLastMentionedSegment));
                    _result.setLastMentionedSegment(_tmpLastMentionedSegment);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                ChannelUnreadEntity channelUnreadEntity = _result;
                return channelUnreadEntity;
            }
        });
    }

    @Override
    public Flowable<Unread> getTotalChannelsUnread() {
        String _sql = "SELECT COALESCE(SUM(channel_unread.unreadCount), 0) as unreadCount, COALESCE(MAX(channel_unread.isMentioned), 0) as isMentioned from channel_unread where channel_unread.channelId in (SELECT channelId from channel)";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel_unread", "channel"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT COALESCE(SUM(channel_unread.unreadCount), 0) as unreadCount, COALESCE(MAX(channel_unread.isMentioned), 0) as isMentioned from channel_unread where channel_unread.channelId in (SELECT channelId from channel)");){
                Unread _result;
                boolean _columnIndexOfUnreadCount = false;
                boolean _columnIndexOfIsMentioned = true;
                if (_stmt.step()) {
                    int _tmpUnreadCount = (int)_stmt.getLong(0);
                    int _tmp = (int)_stmt.getLong(1);
                    boolean _tmpIsMentioned = _tmp != 0;
                    _result = new Unread(_tmpUnreadCount, _tmpIsMentioned);
                } else {
                    _result = null;
                }
                Unread unread = _result;
                return unread;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from channel_unread";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from channel_unread");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void deleteById(String channelId) {
        String _sql = "DELETE from channel_unread where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from channel_unread where channelId = ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

