/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.event;

import androidx.paging.Pager;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.entity.social.event.EventEntity;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.amity.socialcloud.sdk.model.social.event.AmityEvent;
import com.amity.socialcloud.sdk.model.social.event.AmityEventOriginType;
import com.amity.socialcloud.sdk.model.social.event.AmityEventRSVPStatus;
import com.amity.socialcloud.sdk.model.social.event.AmityEventStatus;
import com.amity.socialcloud.sdk.model.social.event.AmityEventType;
import com.amity.socialcloud.sdk.social.data.event.EventLocalDataStore;
import com.amity.socialcloud.sdk.social.data.event.EventModelMapper;
import com.amity.socialcloud.sdk.social.data.event.EventRemoteDataStore;
import com.amity.socialcloud.sdk.social.data.event.EventRepository;
import com.amity.socialcloud.sdk.social.data.event.paging.EventQueryPagingSource;
import com.amity.socialcloud.sdk.social.data.event.paging.MyEventsPagingSource;
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.rx3.RxConvertKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016JS\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00100\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00100\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001dJ\u008d\u0001\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f2\b\u0010 \u001a\u0004\u0018\u00010\t2\b\u0010!\u001a\u0004\u0018\u00010\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\"\u001a\u0004\u0018\u00010\u001a2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\b\u0010&\u001a\u0004\u0018\u00010\t2\b\u0010'\u001a\u0004\u0018\u00010\t2\b\u0010(\u001a\u0004\u0018\u00010\t2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010,J}\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u0010.\u001a\u00020\t2\b\u0010 \u001a\u0004\u0018\u00010\t2\b\u0010!\u001a\u0004\u0018\u00010\t2\b\u0010\"\u001a\u0004\u0018\u00010\u001a2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010$2\b\u0010&\u001a\u0004\u0018\u00010\t2\b\u0010'\u001a\u0004\u0018\u00010\t2\b\u0010(\u001a\u0004\u0018\u00010\t2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010/J\u000e\u00100\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\t\u00a8\u00061"}, d2={"Lcom/amity/socialcloud/sdk/social/data/event/EventRepository;", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Lcom/amity/socialcloud/sdk/entity/social/event/EventEntity;", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEvent;", "<init>", "()V", "fetchAndSave", "Lio/reactivex/rxjava3/core/Completable;", "objectId", "", "queryFromCache", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "Lio/reactivex/rxjava3/core/Flowable;", "getEventPagingData", "Landroidx/paging/PagingData;", "originType", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEventOriginType;", "originId", "userId", "status", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEventStatus;", "type", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEventType;", "onlyAttended", "", "(Lcom/amity/socialcloud/sdk/model/social/event/AmityEventOriginType;Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/social/event/AmityEventStatus;Lcom/amity/socialcloud/sdk/model/social/event/AmityEventType;Ljava/lang/Boolean;)Lio/reactivex/rxjava3/core/Flowable;", "getMyEventsPagingData", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEventRSVPStatus;", "createEvent", "Lio/reactivex/rxjava3/core/Single;", "title", "description", "isInviteOnly", "startTime", "Lorg/joda/time/DateTime;", "endTime", "location", "externalUrl", "coverImageFileId", "tags", "Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;", "timezone", "(Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/social/event/AmityEventType;Ljava/lang/Boolean;Lorg/joda/time/DateTime;Lorg/joda/time/DateTime;Lcom/amity/socialcloud/sdk/model/social/event/AmityEventOriginType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/String;)Lio/reactivex/rxjava3/core/Single;", "updateEvent", "eventId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Lorg/joda/time/DateTime;Lorg/joda/time/DateTime;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/String;)Lio/reactivex/rxjava3/core/Single;", "deleteEvent", "amity-sdk_release"})
public final class EventRepository
extends AmityObjectRepository<EventEntity, AmityEvent> {
    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new EventRemoteDataStore().getEvent(objectId).flatMapCompletable((Function)fetchAndSave.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @Override
    @Nullable
    public EventEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new EventLocalDataStore().getEvent(objectId);
    }

    @Override
    @NotNull
    public ModelMapper<EventEntity, AmityEvent> mapper() {
        return new EventModelMapper();
    }

    @Override
    @NotNull
    public Flowable<EventEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new EventLocalDataStore().observeEvent(objectId);
    }

    @NotNull
    public final Flowable<PagingData<AmityEvent>> getEventPagingData(@Nullable AmityEventOriginType originType, @Nullable String originId, @Nullable String userId, @Nullable AmityEventStatus status, @Nullable AmityEventType type2, @Nullable Boolean onlyAttended) {
        Pager pager = new Pager(new PagingConfig(20, 0, false, 20, 0, 0, 50, null), null, () -> EventRepository.getEventPagingData$lambda$0(originType, originId, userId, status, type2, onlyAttended), 2, null);
        Flowable flowable = RxConvertKt.asFlowable$default((Flow)pager.getFlow(), null, (int)1, null).map((Function)getEventPagingData.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<PagingData<AmityEvent>> getMyEventsPagingData(@Nullable AmityEventRSVPStatus status) {
        Pager pager = new Pager(new PagingConfig(20, 0, false, 20, 0, 0, 50, null), null, () -> EventRepository.getMyEventsPagingData$lambda$1(status), 2, null);
        Flowable flowable = RxConvertKt.asFlowable$default((Flow)pager.getFlow(), null, (int)1, null).map((Function)getMyEventsPagingData.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @NotNull
    public final Single<AmityEvent> createEvent(@Nullable String title, @Nullable String description, @Nullable AmityEventType type2, @Nullable Boolean isInviteOnly, @Nullable DateTime startTime, @NotNull DateTime endTime, @NotNull AmityEventOriginType originType, @NotNull String originId, @Nullable String location, @Nullable String externalUrl, @Nullable String coverImageFileId, @Nullable AmityTags tags, @Nullable String timezone) {
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter((Object)((Object)originType), (String)"originType");
        Intrinsics.checkNotNullParameter((Object)originId, (String)"originId");
        Single single = new EventRemoteDataStore().createEvent(title, description, type2, isInviteOnly, startTime, endTime, originType, originId, location, externalUrl, coverImageFileId, tags, timezone).flatMap((Function)createEvent.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"flatMap(...)");
        return single;
    }

    @NotNull
    public final Single<AmityEvent> updateEvent(@NotNull String eventId, @Nullable String title, @Nullable String description, @Nullable Boolean isInviteOnly, @Nullable DateTime startTime, @Nullable DateTime endTime, @Nullable String location, @Nullable String externalUrl, @Nullable String coverImageFileId, @Nullable AmityTags tags, @Nullable String timezone) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Single single = new EventRemoteDataStore().updateEvent(eventId, title, description, isInviteOnly, startTime, endTime, location, externalUrl, coverImageFileId, tags, timezone).flatMap((Function)updateEvent.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"flatMap(...)");
        return single;
    }

    @NotNull
    public final Completable deleteEvent(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Completable completable = new EventRemoteDataStore().deleteEvent(eventId).flatMapCompletable(new Function(eventId){
            final /* synthetic */ String $eventId;
            {
                this.$eventId = $eventId;
            }

            public final CompletableSource apply(EkoDeletionDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.isSuccess() ? (CompletableSource)new EventLocalDataStore().deleteEvent(this.$eventId) : (CompletableSource)Completable.complete();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    private static final PagingSource getEventPagingData$lambda$0(AmityEventOriginType $originType, String $originId, String $userId, AmityEventStatus $status, AmityEventType $type, Boolean $onlyAttended) {
        return (PagingSource)new EventQueryPagingSource($originType, $originId, $userId, $status, $type, $onlyAttended);
    }

    private static final PagingSource getMyEventsPagingData$lambda$1(AmityEventRSVPStatus $status) {
        return (PagingSource)new MyEventsPagingSource($status);
    }
}

