/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.comment;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentDataTypeFilter;
import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentSortOption;
import com.amity.socialcloud.sdk.model.social.comment.AmityComment;
import com.amity.socialcloud.sdk.social.data.comment.CommentModelMapper;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentDao;
import com.ekoapp.ekosdk.internal.entity.CommentEntity;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bJ$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000bJU\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\b0\u001e2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u001b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%\u00a2\u0006\u0002\u0010&JE\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u001b2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001f\u00a2\u0006\u0002\u0010+J \u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00152\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007J\u000e\u0010.\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b\u00a8\u0006/"}, d2={"Lcom/amity/socialcloud/sdk/social/data/comment/CommentLocalDataStore;", "", "<init>", "()V", "saveComments", "Lio/reactivex/rxjava3/core/Completable;", "comments", "", "Lcom/ekoapp/ekosdk/internal/entity/CommentEntity;", "getComment", "commentId", "", "notifyParentComment", "", "parentId", "getLatestComments", "Lcom/amity/socialcloud/sdk/model/social/comment/AmityComment;", "referenceType", "referenceId", "getLatestReplies", "observeComment", "Lio/reactivex/rxjava3/core/Flowable;", "markDeletedAfterCommentId", "markDeletedBeforeCommentId", "hardDelete", "softDelete", "hasInLocal", "", "deleteByReferenceId", "getCommentPagingSource", "Landroidx/paging/PagingSource;", "", "isFilterByParentId", "isDeleted", "sortOption", "Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentSortOption;", "dataTypeFilter", "Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentDataTypeFilter;", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentSortOption;Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentDataTypeFilter;)Landroidx/paging/PagingSource;", "getLatestComment", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;I)Lio/reactivex/rxjava3/core/Flowable;", "getCommentByIds", "postIds", "decrementChildCount", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nCommentLocalDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentLocalDataStore.kt\ncom/amity/socialcloud/sdk/social/data/comment/CommentLocalDataStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1563#2:166\n1634#2,3:167\n1563#2:170\n1634#2,3:171\n*S KotlinDebug\n*F\n+ 1 CommentLocalDataStore.kt\ncom/amity/socialcloud/sdk/social/data/comment/CommentLocalDataStore\n*L\n48#1:166\n48#1:167,3\n72#1:170\n72#1:171,3\n*E\n"})
public final class CommentLocalDataStore {
    @NotNull
    public final Completable saveComments(@NotNull List<CommentEntity> comments) {
        Intrinsics.checkNotNullParameter(comments, (String)"comments");
        Completable completable = Completable.fromAction(() -> CommentLocalDataStore.saveComments$lambda$0(comments));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @Nullable
    public final CommentEntity getComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Ref.ObjectRef comment = new Ref.ObjectRef();
        Completable.fromCallable(() -> CommentLocalDataStore.getComment$lambda$1(commentId, comment)).subscribeOn(Schedulers.io()).blockingAwait();
        return (CommentEntity)comment.element;
    }

    public final void notifyParentComment(@NotNull String parentId) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        UserDatabase.get().commentDao().updateComment(parentId);
    }

    @NotNull
    public final List<AmityComment> getLatestComments(@NotNull String referenceType, @NotNull String referenceId) {
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Ref.ObjectRef comments = new Ref.ObjectRef();
        comments.element = CollectionsKt.emptyList();
        Completable.fromCallable(() -> CommentLocalDataStore.getLatestComments$lambda$3(referenceType, referenceId, comments)).subscribeOn(Schedulers.io()).blockingAwait();
        return (List)comments.element;
    }

    @NotNull
    public final List<AmityComment> getLatestReplies(@NotNull String referenceType, @NotNull String referenceId, @NotNull String parentId) {
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Ref.ObjectRef comments = new Ref.ObjectRef();
        comments.element = CollectionsKt.emptyList();
        Completable.fromCallable(() -> CommentLocalDataStore.getLatestReplies$lambda$5(parentId, referenceType, referenceId, comments)).subscribeOn(Schedulers.io()).blockingAwait();
        return (List)comments.element;
    }

    @NotNull
    public final Flowable<CommentEntity> observeComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Flowable<CommentEntity> flowable = UserDatabase.get().commentDao().getById(commentId);
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"getById(...)");
        return flowable;
    }

    public final void markDeletedAfterCommentId(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        UserDatabase.get().commentDao().markAllDeletedAfterCommentId(commentId);
    }

    public final void markDeletedBeforeCommentId(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        UserDatabase.get().commentDao().markAllDeletedBeforeCommentId(commentId);
    }

    @NotNull
    public final Completable hardDelete(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Completable completable = UserDatabase.get().commentDao().deleteById(commentId);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"deleteById(...)");
        return completable;
    }

    @NotNull
    public final Completable softDelete(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Completable completable = UserDatabase.get().commentDao().softDeleteById(commentId);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"softDeleteById(...)");
        return completable;
    }

    public final boolean hasInLocal(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Ref.BooleanRef hasInLocal = new Ref.BooleanRef();
        Completable.fromCallable(() -> CommentLocalDataStore.hasInLocal$lambda$6(commentId, hasInLocal)).subscribeOn(Schedulers.io()).blockingAwait();
        return hasInLocal.element;
    }

    @NotNull
    public final Completable deleteByReferenceId(@NotNull String referenceId) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        EkoCommentDao commentDao = UserDatabase.get().commentDao();
        Completable completable = commentDao.deleteByReferenceId(referenceId);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"deleteByReferenceId(...)");
        return completable;
    }

    @NotNull
    public final PagingSource<Integer, CommentEntity> getCommentPagingSource(@NotNull String referenceId, @NotNull String referenceType, boolean isFilterByParentId, @Nullable String parentId, @Nullable Boolean isDeleted, @NotNull AmityCommentSortOption sortOption, @Nullable AmityCommentDataTypeFilter dataTypeFilter) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        return UserDatabase.get().commentPagingDao().getCommentPagingSource(referenceId, referenceType, isFilterByParentId, parentId, isDeleted, sortOption, dataTypeFilter);
    }

    @NotNull
    public final Flowable<CommentEntity> getLatestComment(@NotNull String referenceId, @NotNull String referenceType, @Nullable String parentId, @Nullable Boolean isDeleted, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Flowable<CommentEntity> flowable = UserDatabase.get().commentDao().getLatestComment(referenceType, referenceId, parentId, isDeleted, dynamicQueryStreamKeyCreator.hashCode(), nonce);
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"getLatestComment(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<List<CommentEntity>> getCommentByIds(@NotNull List<String> postIds) {
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        Flowable<List<CommentEntity>> flowable = UserDatabase.get().commentDao().getByCommentIds(postIds);
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"getByCommentIds(...)");
        return flowable;
    }

    public final void decrementChildCount(@NotNull String parentId) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        UserDatabase.get().commentDao().decrementChildCount(parentId);
    }

    private static final void saveComments$lambda$0(List $comments) {
        UserDatabase.get().commentDao().save($comments);
    }

    private static final Unit getComment$lambda$1(String $commentId, Ref.ObjectRef $comment) {
        CommentEntity entity = UserDatabase.get().commentDao().getByIdNow($commentId);
        if (entity != null) {
            $comment.element = entity;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit getLatestComments$lambda$3(String $referenceType, String $referenceId, Ref.ObjectRef $comments) {
        EkoCommentDao commentDao = UserDatabase.get().commentDao();
        List<CommentEntity> entities = commentDao.getLatestComments($referenceType, $referenceId);
        Intrinsics.checkNotNull(entities);
        if (!((Collection)entities).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = entities;
            Ref.ObjectRef objectRef = $comments;
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CommentEntity commentEntity = (CommentEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                CommentModelMapper commentModelMapper = new CommentModelMapper();
                Intrinsics.checkNotNull((Object)it);
                collection.add(commentModelMapper.map((CommentEntity)it));
            }
            objectRef.element = (List)destination$iv$iv;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit getLatestReplies$lambda$5(String $parentId, String $referenceType, String $referenceId, Ref.ObjectRef $comments) {
        EkoCommentDao commentDao = UserDatabase.get().commentDao();
        List<CommentEntity> entities = commentDao.getLatestReplies($parentId, $referenceType, $referenceId, AmityCommentSortOption.LAST_CREATED);
        Intrinsics.checkNotNull(entities);
        if (!((Collection)entities).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = entities;
            Ref.ObjectRef objectRef = $comments;
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CommentEntity commentEntity = (CommentEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                CommentModelMapper commentModelMapper = new CommentModelMapper();
                Intrinsics.checkNotNull((Object)it);
                collection.add(commentModelMapper.map((CommentEntity)it));
            }
            objectRef.element = (List)destination$iv$iv;
        }
        return Unit.INSTANCE;
    }

    private static final Unit hasInLocal$lambda$6(String $commentId, Ref.BooleanRef $hasInLocal) {
        EkoCommentDao commentDao = UserDatabase.get().commentDao();
        CommentEntity entity = commentDao.getByIdNow($commentId);
        if (entity != null) {
            $hasInLocal.element = true;
        }
        return Unit.INSTANCE;
    }
}

