/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.session.component;

import android.util.Log;
import com.amity.socialcloud.sdk.core.domain.session.GetCurrentAccountUseCase;
import com.amity.socialcloud.sdk.core.session.TokenVerifier;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenWatcherSessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0002J\b\u0010\u001a\u001a\u00020\u0011H\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0002J\b\u0010\u001c\u001a\u00020\u0011H\u0002J\b\u0010\u001d\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/amity/socialcloud/sdk/core/session/component/TokenWatcherSessionComponent;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "<init>", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "compositeDisposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "getCompositeDisposable", "()Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "setCompositeDisposable", "(Lio/reactivex/rxjava3/disposables/CompositeDisposable;)V", "onSessionStateChange", "", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "destroy", "handleTokenExpire", "checkAccessTokenExpiration", "observeSessionState", "observeAppEvent", "startTokenWatcherInterval", "disposeSubscription", "amity-sdk_release"})
public final class TokenWatcherSessionComponent
extends SessionComponent {
    @NotNull
    private final AppEventBus appEventBus;
    @NotNull
    private CompositeDisposable compositeDisposable;

    public TokenWatcherSessionComponent(@NotNull AppEventBus appEventBus, @NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)appEventBus, (String)"appEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.appEventBus = appEventBus;
        this.compositeDisposable = new CompositeDisposable();
    }

    @NotNull
    public final CompositeDisposable getCompositeDisposable() {
        return this.compositeDisposable;
    }

    public final void setCompositeDisposable(@NotNull CompositeDisposable compositeDisposable) {
        Intrinsics.checkNotNullParameter((Object)compositeDisposable, (String)"<set-?>");
        this.compositeDisposable = compositeDisposable;
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.disposeSubscription();
        this.compositeDisposable = new CompositeDisposable();
        this.observeSessionState();
        this.observeAppEvent();
        this.startTokenWatcherInterval();
    }

    @Override
    public void destroy() {
        this.disposeSubscription();
    }

    @Override
    public void handleTokenExpire() {
        this.disposeSubscription();
    }

    private final void checkAccessTokenExpiration() {
        new GetCurrentAccountUseCase().execute().doOnSuccess(new Consumer(this){
            final /* synthetic */ TokenWatcherSessionComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(EkoAccount it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TokenVerifier.Result tokenResult = TokenVerifier.Companion.checkExpiration(it);
                Log.e((String)"SSM3", (String)("token verification result: " + tokenResult));
                if (tokenResult == TokenVerifier.Result.ABOUT_TO_EXPIRE) {
                    TokenWatcherSessionComponent.access$getAppEventBus$p(this.this$0).publish(AppEvent.TokenAboutToExpire.INSTANCE);
                } else if (tokenResult == TokenVerifier.Result.EXPIRED) {
                    TokenWatcherSessionComponent.access$getAppEventBus$p(this.this$0).publish(AppEvent.TokenExpire.INSTANCE);
                }
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    private final void observeSessionState() {
        Disposable disposable = this.getSessionStateEventBus().observe().doOnNext(new Consumer(this){
            final /* synthetic */ TokenWatcherSessionComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(SessionState sessionState) {
                Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
                if (Intrinsics.areEqual((Object)sessionState, (Object)SessionState.Established.INSTANCE)) {
                    TokenWatcherSessionComponent.access$checkAccessTokenExpiration(this.this$0);
                }
            }
        }).subscribeOn(Schedulers.io()).subscribe();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        Disposable sessionStateDisposable2 = disposable;
        this.compositeDisposable.add(sessionStateDisposable2);
    }

    private final void observeAppEvent() {
        Disposable disposable = this.appEventBus.observe().filter((Predicate)observeAppEvent.appEventDisposable.1.INSTANCE).doOnNext(new Consumer(this){
            final /* synthetic */ TokenWatcherSessionComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(AppEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TokenWatcherSessionComponent.access$checkAccessTokenExpiration(this.this$0);
            }
        }).subscribeOn(Schedulers.io()).subscribe();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        Disposable appEventDisposable2 = disposable;
        this.compositeDisposable.add(appEventDisposable2);
    }

    private final void startTokenWatcherInterval() {
        Disposable disposable = Flowable.interval((long)1L, (TimeUnit)TimeUnit.MINUTES, (Scheduler)Schedulers.io()).doOnNext(new Consumer(this){
            final /* synthetic */ TokenWatcherSessionComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Long it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TokenWatcherSessionComponent.access$checkAccessTokenExpiration(this.this$0);
            }
        }).subscribe();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        Disposable tokenIntervalDisposable2 = disposable;
        this.compositeDisposable.add(tokenIntervalDisposable2);
    }

    private final void disposeSubscription() {
        this.compositeDisposable.dispose();
        this.compositeDisposable.clear();
    }

    public static final /* synthetic */ AppEventBus access$getAppEventBus$p(TokenWatcherSessionComponent $this) {
        return $this.appEventBus;
    }

    public static final /* synthetic */ void access$checkAccessTokenExpiration(TokenWatcherSessionComponent $this) {
        $this.checkAccessTokenExpiration();
    }
}

