package com.ekoapp.ekosdk.internal.usecase.post

import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.model.core.file.AmityAudio
import com.amity.socialcloud.sdk.model.core.file.AmityClip
import com.amity.socialcloud.sdk.model.core.file.AmityFile
import com.amity.socialcloud.sdk.model.core.file.AmityFileInfo
import com.amity.socialcloud.sdk.model.core.file.AmityImage
import com.amity.socialcloud.sdk.model.core.file.AmityVideo
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.model.social.post.AmityPostAttachment
import com.google.common.collect.FluentIterable

internal interface PostCreateUseCase {

    fun mapMentionees(userIds: List<String>?): List<AmityMentioneeTarget>? {
        return if (userIds.isNullOrEmpty()) {
            null
        } else {
            listOf(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
        }
    }

    fun mapAttachments(
        files: List<AmityFileInfo>,
        dataType: String = "file",
        fileId: String? = null,
        displayMode: String? = null,
        isMuted: Boolean? = null,
    ): List<AmityPostAttachment> {
        return FluentIterable.from(files)
            .transform { file ->
                val type = file?.rawFile?.getFileType()?.apiKey ?: dataType
                AmityPostAttachment(
                    fileId = fileId ?: file!!.getFileId(),
                    type = type,
                    displayMode = displayMode,
                    isMuted = isMuted
                )
            }
            .toList()
    }

}