package com.amity.socialcloud.sdk.social.data.event.paging

import androidx.paging.PagingState
import androidx.paging.rxjava3.RxPagingSource
import com.amity.socialcloud.sdk.entity.social.event.EventEntity
import com.amity.socialcloud.sdk.model.social.event.AmityEventRSVPStatus
import com.amity.socialcloud.sdk.social.data.event.EventEntityMapper
import com.amity.socialcloud.sdk.social.data.event.EventQueryPersister
import com.amity.socialcloud.sdk.social.data.event.EventRemoteDataStore
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers

internal class MyEventsPagingSource(
    private val status: AmityEventRSVPStatus?
) : RxPagingSource<String, EventEntity>() {

    override fun loadSingle(params: LoadParams<String>): Single<LoadResult<String, EventEntity>> {
        return EventRemoteDataStore().getMyEvents(
            status = status,
            limit = params.loadSize,
            token = params.key
        )
            .flatMap { dto ->
                EventQueryPersister().persist(dto)
                    .andThen(
                        Single.just(
                            LoadResult.Page(
                                data = dto.events?.mapNotNull { eventDto ->
                                    EventEntityMapper().map(listOf(eventDto)).firstOrNull()
                                } ?: emptyList(),
                                prevKey = null, // Event API doesn't support backward pagination
                                nextKey = dto.paging?.next
                            ) as LoadResult<String, EventEntity>
                        )
                    )
            }
            .onErrorReturn { error ->
                LoadResult.Error(error)
            }
            .subscribeOn(Schedulers.io())
    }

    override fun getRefreshKey(state: PagingState<String, EventEntity>): String? {
        return null
    }
}
