package com.amity.socialcloud.sdk.core.data.pin

import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.PinnedPostQueryDto
import io.reactivex.rxjava3.core.Single

internal class PinRemoteDataStore {
	fun queryPinPost(
		communityId: String,
		placement: String? = null,
		includeMixedStructure: Boolean
	): Single<PinnedPostQueryDto> {
		return AmityHttpClient.get(PinApi::class).flatMap {
			if (placement == null) {
				it.queryPinPost(communityId = communityId, includeMixedStructure = includeMixedStructure)
			} else {
				it.queryPinPostWithPlacement(communityId = communityId, placement = placement, includeMixedStructure = includeMixedStructure)
			}
		}
	}

	fun queryGlobalPinnedPosts(includeMixedStructure: Boolean): Single<PinnedPostQueryDto> {
		return AmityHttpClient.get(PinApi::class).flatMap {
			it.queryGlobalPinnedPost(includeMixedStructure = includeMixedStructure)
		}
	}

}