package com.ekoapp.ekosdk.internal.api.dto

import com.google.gson.annotations.SerializedName
import org.joda.time.DateTime

data class PinDto(
	@SerializedName("referenceId")
    val referenceId: String? = null,
	@SerializedName("referenceType")
    val referenceType: String? = null,
	@SerializedName("placement")
	val placement: String? = null,
	@SerializedName("pinnedBy")
	val pinnedBy: String? = null,
	@SerializedName("pinnedAt")
	val pinnedAt: DateTime? = null,
) {
	fun getId(target: PinTargetDto): String {
		return "${referenceType}_${referenceId}_${placement}_${target.targetType}_${target.targetId}"
	}
}