package com.amity.socialcloud.sdk.core.data.follow

import com.ekoapp.ekosdk.internal.api.dto.EkoFollowListDto
import com.ekoapp.ekosdk.internal.api.dto.EkoFollowQueryDto
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single
import retrofit2.http.*

interface FollowApi {

    @POST("api/v4/me/following/{userId}")
    fun requestFollow(
        @Path("userId") userId: String? = null
    ): Single<EkoFollowListDto>

    @DELETE("api/v4/me/following/{userId}")
    fun unfollow(
        @Path("userId") userId: String? = null
    ): Single<EkoFollowListDto>

    @POST("api/v4/me/followers/{userId}")
    fun acceptFollow(
        @Path("userId") userId: String? = null
    ): Single<EkoFollowListDto>

    @DELETE("api/v4/me/followers/{userId}")
    fun declineFollow(
        @Path("userId") userId: String? = null
    ): Single<EkoFollowListDto>

    @GET("api/v4/me/followInfo")
    fun getMyFollowInfo(): Single<EkoFollowListDto>

    @GET("api/v5/users/{userId}/followInfo")
    fun getUserFollowInfo(
        @Path("userId") userId: String? = null
    ): Single<EkoFollowListDto>

    @GET("api/v4/me/followers")
    fun queryMyFollowers(
        @Query("status") status: String? = null,
        @Query("limit") limit: Int? = null,
        @Query("token") token: String? = null
    ): Single<EkoFollowQueryDto>

    @GET("api/v4/users/{userId}/followers")
    fun queryUserFollowers(
        @Path("userId") userId: String? = null,
        @Query("status") status: String? = null,
        @Query("limit") limit: Int? = null,
        @Query("token") token: String? = null
    ): Single<EkoFollowQueryDto>

    @GET("api/v4/me/following")
    fun queryMyFollowings(
        @Query("status") status: String? = null,
        @Query("limit") limit: Int? = null,
        @Query("token") token: String? = null
    ): Single<EkoFollowQueryDto>

    @GET("api/v4/users/{userId}/following")
    fun queryUserFollowings(
        @Path("userId") userId: String? = null,
        @Query("status") status: String? = null,
        @Query("limit") limit: Int? = null,
        @Query("token") token: String? = null
    ): Single<EkoFollowQueryDto>

    @POST("api/v4/me/user-blocks/{userId}")
    fun blockUser(
        @Path("userId") userId: String? = null
    ): Single<EkoFollowQueryDto>

    @DELETE("api/v4/me/user-blocks/{userId}")
    fun unblockUser(
        @Path("userId") userId: String? = null
    ): Single<EkoFollowQueryDto>

    @GET("api/v4/me/user-blocks")
    fun queryBlockedUsers(
        @Query("limit") limit: Int? = null,
        @Query("token") token: String? = null
    ): Single<EkoFollowQueryDto>
}