package com.amity.socialcloud.sdk.api.social.comment.create


import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.social.comment.AmityComment
import com.google.gson.JsonArray
import com.google.gson.JsonObject


class AmityTextCommentCreator private constructor(
    referenceType: String,
    referenceId: String,
    parentId: String?,
    commentId: String?,
    private val text: String,
    dataTypes: List<String>,
    metadata: JsonObject?,
    mentionees: List<AmityMentioneeTarget>?
) : AmityCommentCreator(
    referenceType,
    referenceId,
    parentId,
    commentId,
    metadata,
    mentionees,
    dataTypes
) {

    override fun getData(): JsonObject {
        val data = JsonObject()
        data.addProperty("text", text)
        return data
    }

    override fun getAttachments(): JsonArray? {
        return null
    }

    class Builder internal constructor() {
        private var referenceType: String = ""
        private var referenceId: String = ""
        private var parentId: String? = null
        private var text: String = ""
        private var commentId: String? = null
        private var metadata: JsonObject? = null
        private var mentionees: List<AmityMentioneeTarget>? = null
        private var dataTypes: MutableList<String> = mutableListOf()

        internal fun referenceType(referenceType: String): Builder {
            return apply { this.referenceType = referenceType }
        }

        internal fun referenceId(referenceId: String): Builder {
            return apply { this.referenceId = referenceId }
        }

        internal fun parentId(parentId: String?): Builder {
            return apply { this.parentId = parentId }
        }

        internal fun text(text: String): Builder {
            return apply {
                if (text.isNotEmpty()) {
                    this.text = text
                    dataTypes.add(AmityComment.DataType.TEXT.apiKey)
                }
            }
        }

        internal fun commentId(commentId: String?): Builder {
            return apply {
                this.commentId = commentId
            }
        }

        /**
         * @param [metadata] to add metadata to the comment
         * @return the same instance of AmityTextCommentCreator.Builder
         */
        fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }

        /**
         * @param [userIds] list of userId to be mentioned by this comment
         * @return the same instance of AmityTextCommentCreator.Builder
         */
        fun mentionUsers(userIds: List<String>): Builder {
            this.mentionees = listOf(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
            return this
        }

        /**
         * Instantiates AmityTextCommentCreator with built params.
         * @return new instance of AmityTextCommentCreator.
         */
        fun build(): AmityTextCommentCreator {
            return AmityTextCommentCreator(
                referenceType,
                referenceId,
                parentId,
                commentId,
                text,
                dataTypes,
                metadata,
                mentionees
            )
        }
    }

}
