package com.amity.socialcloud.sdk.model.chat.channel

import com.amity.socialcloud.sdk.model.chat.member.AmityMembershipType

enum class AmityChannelFilter(val apiKey: String, val memberships: List<String>) {
    ALL("all", emptyList<String>()),
    MEMBER("member", listOf(AmityMembershipType.MEMBER.apiKey)),
    NOT_MEMBER("notMember", listOf(AmityMembershipType.NONE.apiKey, AmityMembershipType.BANNED.apiKey));

    companion object {
        fun enumOf(apiKey: String) : AmityChannelFilter {
            return values().find {
                it.apiKey == apiKey
            } ?: ALL
        }
    }

}