package com.amity.socialcloud.sdk.api.core.follow

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.api.core.follow.query.AmityMyFollowersQuery
import com.amity.socialcloud.sdk.api.core.follow.query.AmityMyFollowingsQuery
import com.amity.socialcloud.sdk.api.core.follow.query.AmityUserFollowersQuery
import com.amity.socialcloud.sdk.api.core.follow.query.AmityUserFollowingsQuery
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatus
import com.amity.socialcloud.sdk.model.core.follow.AmityMyFollowInfo
import com.amity.socialcloud.sdk.model.core.follow.AmityUserFollowInfo
import com.ekoapp.ekosdk.internal.usecase.user.*
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.core.Single

class AmityRelationShip internal constructor() {

    @Deprecated("Use AmityCoreClient.newUserRepository().relationship() instead")
    fun me(): AmityMyUserRelationship {
        return AmityMyUserRelationship()
    }

    @Deprecated("Use AmityCoreClient.newUserRepository().relationship() instead")
    fun user(userId: String): AmityUserRelationship {
        return AmityUserRelationship(userId)
    }

    /* begin_public_function
      id: user.relationship.follow
    */
    fun follow(userId: String): Single<AmityFollowStatus> {
        return UserFollowRequestUseCase().execute(userId)
    }
    /* end_public_function */

    /* begin_public_function
      id: user.relationship.unfollow
    */
    fun unfollow(userId: String): Completable {
        return UnfollowUseCase().execute(userId)
    }
    /* end_public_function */

    /* begin_public_function
      id: user.relationship.accept_follow
    */
    fun acceptMyFollower(userId: String): Completable {
        return AcceptFollowUseCase().execute(userId)
    }
    /* end_public_function */

    /* begin_public_function
      id: user.relationship.decline_follow
    */
    fun declineMyFollower(userId: String): Completable {
        return DeclineFollowUseCase().execute(userId)
    }
    /* end_public_function */

    fun removeMyFollower(userId: String): Completable {
        return RemoveFollowerUseCase().execute(userId)
    }

    /* begin_public_function
      id: user.relationship.query_my_followings
      api_style: live_collection
    */
    fun getMyFollowings(): AmityMyFollowingsQuery.Builder {
        return AmityMyFollowingsQuery.Builder()
    }
    /* end_public_function */

    /* begin_public_function
      id: user.relationship.query_followings
      api_style: live_collection
    */
    fun getFollowings(userId: String): AmityUserFollowingsQuery.Builder {
        return AmityUserFollowingsQuery.Builder(userId)
    }
    /* end_public_function */

    /* begin_public_function
      id: user.relationship.query_my_followers
      api_style: live_collection
    */
    fun getMyFollowers(): AmityMyFollowersQuery.Builder {
        return AmityMyFollowersQuery.Builder()
    }
    /* end_public_function */

    /* begin_public_function
      id: user.relationship.query_followers
      api_style: live_collection
    */
    fun getFollowers(userId: String): AmityUserFollowersQuery.Builder {
        return AmityUserFollowersQuery.Builder(userId)
    }
    /* end_public_function */

    /* begin_public_function
      id: user.relationship.get_my_follow_info
    */
    fun getMyFollowInfo(): Flowable<AmityMyFollowInfo> {
        return MyFollowLiveObjectUseCase().execute(AmityCoreClient.getUserId())
    }
    /* end_public_function */

    /* begin_public_function
      id: user.relationship.get_follow_info
    */
    fun getFollowInfo(userId: String): Flowable<AmityUserFollowInfo> {
        return GetUserFollowInfoUseCase().execute(userId)
    }
    /* end_public_function */

    /* begin_public_function
     id: user.relationship.block
    */
    fun blockUser(userId: String): Completable {
        return BlockUserUseCase().execute(userId)
    }
    /* end_public_function */

    /* begin_public_function
         id: user.relationship.unblock
    */
    fun unblockUser(userId: String): Completable {
        return UnblockUserUseCase().execute(userId)
    }
    /* end_public_function */
}