package com.amity.socialcloud.sdk.chat.data.marker.channel

import com.amity.socialcloud.sdk.log.AmityLog
import com.amity.socialcloud.sdk.model.core.unread.UserUnread
import com.ekoapp.ekosdk.internal.ChannelMarkerEntity
import com.ekoapp.ekosdk.internal.ChannelUnreadEntity
import com.ekoapp.ekosdk.internal.ChannelUnreadInfoEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable

internal class ChannelMarkerLocalDataStore {

    fun getChannelMarker(channelId: String): ChannelMarkerEntity? {
        return UserDatabase.get().channelMarkerDao().getByIdNow(channelId)
    }

    fun saveChannelMarkers(
        channelMarkers: List<ChannelMarkerEntity>,
    ): Completable {
        return Completable.fromAction {
            UserDatabase.get().channelMarkerDao().save(channelMarkers)
        }
    }

    fun getChannelUnreadInfo(channelId: String): ChannelUnreadInfoEntity? {
        return UserDatabase.get().channelUnreadInfoDao().getByChannelIdNow(channelId)
    }

    fun saveChannelUnreadInfo(
        channelUnreadInfos: List<ChannelUnreadInfoEntity>,
    ) {
        UserDatabase.get().channelUnreadInfoDao().save(channelUnreadInfos)
    }

    fun getTotalChannelsUnreadInfo(): Flowable<UserUnread> {
        return UserDatabase.get().channelUnreadInfoDao().getTotalChannelsUnreadInfo()
            .map {
                UserUnread(it.unreadCount, it.isMentioned, it.isMentioned)
            }
    }

    fun getChannelUnread(channelId: String): ChannelUnreadEntity? {
        return UserDatabase.get().channelUnreadDao().getByChannelIdNow(channelId)
    }

    fun saveChannelUnread(channelUnread: List<ChannelUnreadEntity>) {
        channelUnread.map { unread ->
            val cache = UserDatabase.get().channelUnreadDao().getByChannelIdNow(unread.channelId);
            if (cache != null) {
                unread.readToSegment = if (cache.readToSegment == null || (unread.readToSegment
                                ?: 0) > (cache.readToSegment ?: 0)) {
                    unread.readToSegment
                } else {
                    cache.readToSegment
                }
                unread.lastSegment = if (unread.lastSegment > cache.lastSegment) {
                    unread.lastSegment
                } else {
                    cache.lastSegment
                }
                unread.lastMentionedSegment = if (cache.lastMentionedSegment == null || (unread.lastMentionedSegment
                                ?: 0) > (cache.lastMentionedSegment ?: 0)) {
                    unread.lastMentionedSegment
                } else {
                    cache.lastMentionedSegment
                }
                unread.isDeleted = unread.isDeleted || cache.isDeleted
                unread.unreadCount = (unread.lastSegment - (unread.readToSegment ?: unread.lastSegment)).let {
                    if (it < 0) {
                        0
                    } else {
                        it
                    }
                }
                unread.isMentioned = unread.lastMentionedSegment?.let { it != 0 && it < unread.lastSegment } ?: false
            }
            unread
        }.let(UserDatabase.get().channelUnreadDao()::save)
    }

    fun getTotalChannelsUnread(): Flowable<UserUnread> {
        return UserDatabase.get().channelUnreadDao().getTotalChannelsUnread()
            .map {
                UserUnread(it.unreadCount, it.isMentioned, it.isMentioned)
            }
    }

}