/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core;

import android.os.Build;
import com.amity.socialcloud.sdk.chat.data.marker.readreceipt.ReadReceiptRepository;
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerRepository;
import com.amity.socialcloud.sdk.chat.domain.marker.reader.MarkChannelReadUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.reader.UpdateReadReceiptLatestSyncSegmentUseCase;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.NetworkConnectionEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.NetworkConnectionEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.ekoapp.ekosdk.internal.ChannelReadReceiptEntity;
import com.ekoapp.ekosdk.internal.SubChannelUnreadInfoEntity;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 +2\u00020\u0001:\u0003+,-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u001eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010 \u001a\u00020\u0012H\u0016J\u0016\u0010!\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010!\u001a\u00020\u000f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\u001eH\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010(\u001a\u00020\u0012H\u0002J\b\u0010)\u001a\u00020\u0012H\u0002J\b\u0010*\u001a\u00020\u000fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/amity/socialcloud/sdk/core/ChannelReadReceiptSyncEngine;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "disposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "isActive", "", "jobQueue", "", "Lcom/amity/socialcloud/sdk/core/ChannelReadReceiptSyncEngine$ReadReceiptSyncJob;", "timer", "Lio/reactivex/rxjava3/core/Completable;", "Lio/reactivex/rxjava3/annotations/NonNull;", "destroy", "", "enqueueJob", "syncJob", "enqueueReadReceipt", "subChannelId", "", "segment", "", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "getReadReceipts", "", "getSyncJob", "handleTokenExpire", "markRead", "syncJobs", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "removeSynedReceipt", "channelId", "startObservingReadReceiptQueue", "stopObservingReadReceiptQueue", "syncReadReceipts", "Companion", "ReadReceiptSyncJob", "ReadReceiptSyncState", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nChannelReadReceiptSyncEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelReadReceiptSyncEngine.kt\ncom/amity/socialcloud/sdk/core/ChannelReadReceiptSyncEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,274:1\n1855#2,2:275\n1855#2,2:277\n1549#2:279\n1620#2,3:280\n766#2:283\n857#2,2:284\n1477#2:286\n1502#2,3:287\n1505#2,3:297\n1238#2,2:302\n1963#2,14:304\n1241#2:318\n1603#2,9:319\n1855#2:328\n1856#2:330\n1612#2:331\n1855#2,2:332\n1855#2,2:335\n288#2,2:337\n1855#2,2:339\n361#3,7:290\n442#3:300\n392#3:301\n1#4:329\n1#4:334\n*S KotlinDebug\n*F\n+ 1 ChannelReadReceiptSyncEngine.kt\ncom/amity/socialcloud/sdk/core/ChannelReadReceiptSyncEngine\n*L\n41#1:275,2\n81#1:277,2\n85#1:279\n85#1:280,3\n117#1:283\n117#1:284,2\n118#1:286\n118#1:287,3\n118#1:297,3\n119#1:302,2\n119#1:304,14\n119#1:318\n123#1:319,9\n123#1:328\n123#1:330\n123#1:331\n149#1:332,2\n172#1:335,2\n218#1:337,2\n91#1:339,2\n118#1:290,7\n119#1:300\n119#1:301\n123#1:329\n*E\n"})
public final class ChannelReadReceiptSyncEngine
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isActive;
    @NotNull
    private final List<ReadReceiptSyncJob> jobQueue;
    @NotNull
    private final Completable timer;
    @NotNull
    private final CompositeDisposable disposable;
    private static final int MAX_RETRY = 3;
    private static final int JOB_QUEUE_SIZE = 120;
    private static final long RECEIPT_SYNC_INTERVAL = 1L;

    public ChannelReadReceiptSyncEngine(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.jobQueue = new ArrayList();
        Completable completable = Flowable.interval((long)RECEIPT_SYNC_INTERVAL, (TimeUnit)TimeUnit.SECONDS).flatMapCompletable(new Function(this){
            final /* synthetic */ ChannelReadReceiptSyncEngine this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final CompletableSource apply(long it) {
                return (CompletableSource)ChannelReadReceiptSyncEngine.access$syncReadReceipts(this.this$0).onErrorComplete();
            }
        }).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"interval(RECEIPT_SYNC_IN\u2026scribeOn(Schedulers.io())");
        this.timer = completable;
        this.disposable = new CompositeDisposable();
        Iterable $this$forEach$iv = new ReadReceiptRepository().getUnsyncReadReceipt();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChannelReadReceiptEntity it = (ChannelReadReceiptEntity)element$iv;
            boolean bl = false;
            this.enqueueReadReceipt(it.getChannelId(), it.getLatestSegment());
            this.jobQueue.add(new ReadReceiptSyncJob(it.getChannelId(), it.getLatestSegment(), ReadReceiptSyncState.CREATED, 0));
        }
        if (Intrinsics.areEqual(sessionStateEventBus.getCurrentEvent(), (Object)SessionState.Established.INSTANCE)) {
            this.startObservingReadReceiptQueue();
        }
        NetworkConnectionEventBus.INSTANCE.observe().doOnNext(new Consumer(){

            public final void accept(@NotNull NetworkConnectionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event instanceof NetworkConnectionEvent.Connected) {
                    this.startObservingReadReceiptQueue();
                } else {
                    this.stopObservingReadReceiptQueue();
                }
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    private final Completable syncReadReceipts() {
        Completable completable;
        if (this.jobQueue.size() == 0 || !this.isActive) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"{\n\t\t\tCompletable.complete()\n\t\t}");
        } else {
            List<ReadReceiptSyncJob> readReceipt = this.getReadReceipts();
            if (!((Collection)readReceipt).isEmpty()) {
                completable = this.markRead(readReceipt);
            } else {
                Completable completable3 = Completable.complete();
                completable = completable3;
                Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"{\n\t\t\t\tCompletable.complete()\n\t\t\t}");
            }
        }
        return completable;
    }

    /*
     * WARNING - void declaration
     */
    private final Completable markRead(List<ReadReceiptSyncJob> syncJobs) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        Iterable $this$forEach$iv = syncJobs;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ReadReceiptSyncJob it = (ReadReceiptSyncJob)element$iv2;
            boolean bl = false;
            it.setSyncState(ReadReceiptSyncState.SYNCING);
        }
        Iterable $this$map$iv = syncJobs;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ReadReceiptSyncJob readReceiptSyncJob = (ReadReceiptSyncJob)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)it.getChannelId(), (Object)it.getSegment()));
        }
        List channelsRead = (List)destination$iv$iv;
        Completable completable = new MarkChannelReadUseCase().execute(channelsRead).doOnComplete(() -> ChannelReadReceiptSyncEngine.markRead$lambda$4(syncJobs, this)).doOnError(new Consumer(syncJobs, this){
            final /* synthetic */ List<ReadReceiptSyncJob> $syncJobs;
            final /* synthetic */ ChannelReadReceiptSyncEngine this$0;
            {
                this.$syncJobs = $syncJobs;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final void accept(@NotNull Throwable it) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Iterable iterable = this.$syncJobs;
                ChannelReadReceiptSyncEngine channelReadReceiptSyncEngine = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ReadReceiptSyncJob syncJob = (ReadReceiptSyncJob)element$iv;
                    boolean bl = false;
                    if (syncJob.getRetryCount() > ChannelReadReceiptSyncEngine.Companion.getMAX_RETRY()) {
                        ChannelReadReceiptSyncEngine.access$getJobQueue$p(channelReadReceiptSyncEngine).remove(syncJob);
                        continue;
                    }
                    syncJob.setRetryCount(syncJob.getRetryCount() + 1);
                    syncJob.setSyncState(ReadReceiptSyncState.CREATED);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"private fun markRead(syn\u2026TED\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t}\n\t}");
        return completable;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ReadReceiptSyncJob> getReadReceipts() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapValuesTo$iv$iv;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        Object $this$groupByTo$iv$iv;
        ReadReceiptSyncJob it;
        Iterable $this$filterTo$iv$iv;
        if (this.jobQueue.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List<ReadReceiptSyncJob> syncJob = this.jobQueue;
        Iterable $this$filter$iv = this.jobQueue;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ReadReceiptSyncJob)element$iv$iv;
            boolean bl = false;
            if (!(it.getSyncState() != ReadReceiptSyncState.SYNCING)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            it = (ReadReceiptSyncJob)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getChannelId();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Object v1;
            void entry;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Object object = $this$getOrPut$iv$iv$iv;
            boolean bl3 = false;
            Iterable $this$maxByOrNull$iv = (Iterable)entry.getValue();
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    ReadReceiptSyncJob it2 = (ReadReceiptSyncJob)maxElem$iv;
                    boolean bl4 = false;
                    int maxValue$iv = it2.getSegment();
                    do {
                        Object e$iv = iterator$iv.next();
                        ReadReceiptSyncJob it3 = (ReadReceiptSyncJob)e$iv;
                        $i$a$-maxByOrNull-ChannelReadReceiptSyncEngine$getReadReceipts$jobs$3$1 = false;
                        int v$iv = it3.getSegment();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            ReadReceiptSyncJob readReceiptSyncJob = v1;
            object.put(k, readReceiptSyncJob);
        }
        List jobs = CollectionsKt.filterNotNull((Iterable)destination$iv$iv.values());
        Iterable $this$mapNotNull$iv = jobs;
        boolean $i$f$mapNotNull = false;
        $this$mapValuesTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ReadReceiptSyncJob readReceiptSyncJob;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ReadReceiptSyncJob job = (ReadReceiptSyncJob)element$iv$iv;
            boolean bl5 = false;
            ChannelReadReceiptEntity readReceipt = new ReadReceiptRepository().getReadReceipt(job.getChannelId());
            if (readReceipt != null && readReceipt.getLatestSegment() > readReceipt.getLatestSyncSegment()) {
                job.setSegment(readReceipt.getLatestSegment());
                readReceiptSyncJob = job;
            } else if (readReceipt != null) {
                this.removeSynedReceipt(readReceipt.getChannelId(), readReceipt.getLatestSyncSegment());
                readReceiptSyncJob = null;
            } else {
                readReceiptSyncJob = job;
            }
            if (readReceiptSyncJob == null) continue;
            ReadReceiptSyncJob it$iv$iv = readReceiptSyncJob;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void removeSynedReceipt(String channelId, int segment) {
        if (Build.VERSION.SDK_INT >= 24) {
            this.jobQueue.removeIf(arg_0 -> ChannelReadReceiptSyncEngine.removeSynedReceipt$lambda$10((Function1)new Function1<ReadReceiptSyncJob, Boolean>(channelId, segment){
                final /* synthetic */ String $channelId;
                final /* synthetic */ int $segment;
                {
                    this.$channelId = $channelId;
                    this.$segment = $segment;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ReadReceiptSyncJob syncJob) {
                    Intrinsics.checkNotNullParameter((Object)syncJob, (String)"syncJob");
                    return Intrinsics.areEqual((Object)syncJob.getChannelId(), (Object)this.$channelId) && syncJob.getSegment() <= this.$segment;
                }
            }, arg_0));
        } else {
            Iterable $this$forEach$iv = this.jobQueue;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReadReceiptSyncJob syncJob = (ReadReceiptSyncJob)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)syncJob.getChannelId(), (Object)channelId) || syncJob.getSegment() > segment) continue;
                this.jobQueue.remove(syncJob);
            }
        }
    }

    private final void startObservingReadReceiptQueue() {
        if (!CoreClient.INSTANCE.isUnreadCountEnable()) {
            this.isActive = true;
            if (this.disposable.size() == 0 || this.disposable.isDisposed()) {
                this.disposable.clear();
                Disposable disposable = this.timer.subscribe();
                CompositeDisposable compositeDisposable = this.disposable;
                Disposable p0 = disposable;
                boolean bl = false;
                compositeDisposable.add(p0);
            }
        }
    }

    private final void stopObservingReadReceiptQueue() {
        this.isActive = false;
        if (this.disposable.size() > 0) {
            this.disposable.clear();
        }
        Iterable $this$forEach$iv = this.jobQueue;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReadReceiptSyncJob receipt = (ReadReceiptSyncJob)element$iv;
            boolean bl = false;
            if (receipt.getSyncState() != ReadReceiptSyncState.SYNCING) continue;
            receipt.setSyncState(ReadReceiptSyncState.CREATED);
        }
    }

    public final void markRead(@NotNull String subChannelId, int segment) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        SubChannelUnreadInfoEntity subChannelUnreadInfo = new SubChannelMarkerRepository().getSubChannelUnreadInfo(subChannelId);
        if (subChannelUnreadInfo != null && segment > subChannelUnreadInfo.getReadToSegment()) {
            subChannelUnreadInfo.setReadToSegment(segment);
            new SubChannelMarkerRepository().saveSubChannelUnreadInfo(CollectionsKt.listOf((Object)subChannelUnreadInfo));
        }
        this.enqueueReadReceipt(subChannelId, segment);
    }

    private final void enqueueReadReceipt(String subChannelId, int segment) {
        ChannelReadReceiptEntity readReceipt;
        ChannelReadReceiptEntity channelReadReceiptEntity = new ReadReceiptRepository().getReadReceipt(subChannelId);
        if (channelReadReceiptEntity == null) {
            ChannelReadReceiptEntity channelReadReceiptEntity2;
            ChannelReadReceiptEntity $this$enqueueReadReceipt_u24lambda_u2413 = channelReadReceiptEntity2 = new ChannelReadReceiptEntity();
            boolean bl = false;
            $this$enqueueReadReceipt_u24lambda_u2413.setChannelId(subChannelId);
            $this$enqueueReadReceipt_u24lambda_u2413.setLatestSegment(segment);
            $this$enqueueReadReceipt_u24lambda_u2413.setLatestSyncSegment(0);
            new ReadReceiptRepository().saveReadReceipts(CollectionsKt.listOf((Object)$this$enqueueReadReceipt_u24lambda_u2413));
            channelReadReceiptEntity = channelReadReceiptEntity2;
        }
        if ((readReceipt = channelReadReceiptEntity).getLatestSyncSegment() >= segment) {
            return;
        }
        ReadReceiptSyncJob syncJob = this.getSyncJob(subChannelId);
        if (syncJob == null || syncJob.getSyncState() == ReadReceiptSyncState.SYNCING) {
            syncJob = new ReadReceiptSyncJob(subChannelId, segment, ReadReceiptSyncState.CREATED, 0);
        } else if (syncJob.getSegment() < segment) {
            syncJob.setSegment(segment);
        }
        this.enqueueJob(syncJob);
    }

    private final ReadReceiptSyncJob getSyncJob(String subChannelId) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.jobQueue;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ReadReceiptSyncJob job = (ReadReceiptSyncJob)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)job.getChannelId(), (Object)subChannelId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void enqueueJob(ReadReceiptSyncJob syncJob) {
        if (this.jobQueue.size() > JOB_QUEUE_SIZE) {
            CollectionsKt.removeFirstOrNull(this.jobQueue);
        }
        this.jobQueue.add(syncJob);
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        if (Intrinsics.areEqual((Object)sessionState, (Object)SessionState.Established.INSTANCE)) {
            this.startObservingReadReceiptQueue();
        } else {
            this.stopObservingReadReceiptQueue();
        }
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.startObservingReadReceiptQueue();
    }

    @Override
    public void destroy() {
        this.stopObservingReadReceiptQueue();
        this.jobQueue.clear();
    }

    @Override
    public void handleTokenExpire() {
        this.stopObservingReadReceiptQueue();
    }

    private static final void markRead$lambda$4(List $syncJobs, ChannelReadReceiptSyncEngine this$0) {
        Intrinsics.checkNotNullParameter((Object)$syncJobs, (String)"$syncJobs");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $syncJobs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReadReceiptSyncJob syncJob = (ReadReceiptSyncJob)element$iv;
            boolean bl = false;
            this$0.removeSynedReceipt(syncJob.getChannelId(), syncJob.getSegment());
            new UpdateReadReceiptLatestSyncSegmentUseCase().execute(syncJob.getChannelId(), syncJob.getSegment());
        }
    }

    private static final boolean removeSynedReceipt$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$getJobQueue$p(ChannelReadReceiptSyncEngine $this) {
        return $this.jobQueue;
    }

    public static final /* synthetic */ Completable access$syncReadReceipts(ChannelReadReceiptSyncEngine $this) {
        return $this.syncReadReceipts();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/amity/socialcloud/sdk/core/ChannelReadReceiptSyncEngine$Companion;", "", "()V", "JOB_QUEUE_SIZE", "", "getJOB_QUEUE_SIZE", "()I", "MAX_RETRY", "getMAX_RETRY", "RECEIPT_SYNC_INTERVAL", "", "getRECEIPT_SYNC_INTERVAL", "()J", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMAX_RETRY() {
            return MAX_RETRY;
        }

        public final int getJOB_QUEUE_SIZE() {
            return JOB_QUEUE_SIZE;
        }

        public final long getRECEIPT_SYNC_INTERVAL() {
            return RECEIPT_SYNC_INTERVAL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/amity/socialcloud/sdk/core/ChannelReadReceiptSyncEngine$ReadReceiptSyncJob;", "", "channelId", "", "segment", "", "syncState", "Lcom/amity/socialcloud/sdk/core/ChannelReadReceiptSyncEngine$ReadReceiptSyncState;", "retryCount", "(Ljava/lang/String;ILcom/amity/socialcloud/sdk/core/ChannelReadReceiptSyncEngine$ReadReceiptSyncState;I)V", "getChannelId", "()Ljava/lang/String;", "getRetryCount", "()I", "setRetryCount", "(I)V", "getSegment", "setSegment", "getSyncState", "()Lcom/amity/socialcloud/sdk/core/ChannelReadReceiptSyncEngine$ReadReceiptSyncState;", "setSyncState", "(Lcom/amity/socialcloud/sdk/core/ChannelReadReceiptSyncEngine$ReadReceiptSyncState;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "amity-sdk_release"})
    public static final class ReadReceiptSyncJob {
        @NotNull
        private final String channelId;
        private int segment;
        @NotNull
        private ReadReceiptSyncState syncState;
        private int retryCount;

        public ReadReceiptSyncJob(@NotNull String channelId, int segment, @NotNull ReadReceiptSyncState syncState, int retryCount) {
            Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
            Intrinsics.checkNotNullParameter((Object)((Object)syncState), (String)"syncState");
            this.channelId = channelId;
            this.segment = segment;
            this.syncState = syncState;
            this.retryCount = retryCount;
        }

        @NotNull
        public final String getChannelId() {
            return this.channelId;
        }

        public final int getSegment() {
            return this.segment;
        }

        public final void setSegment(int n) {
            this.segment = n;
        }

        @NotNull
        public final ReadReceiptSyncState getSyncState() {
            return this.syncState;
        }

        public final void setSyncState(@NotNull ReadReceiptSyncState readReceiptSyncState) {
            Intrinsics.checkNotNullParameter((Object)((Object)readReceiptSyncState), (String)"<set-?>");
            this.syncState = readReceiptSyncState;
        }

        public final int getRetryCount() {
            return this.retryCount;
        }

        public final void setRetryCount(int n) {
            this.retryCount = n;
        }

        @NotNull
        public final String component1() {
            return this.channelId;
        }

        public final int component2() {
            return this.segment;
        }

        @NotNull
        public final ReadReceiptSyncState component3() {
            return this.syncState;
        }

        public final int component4() {
            return this.retryCount;
        }

        @NotNull
        public final ReadReceiptSyncJob copy(@NotNull String channelId, int segment, @NotNull ReadReceiptSyncState syncState, int retryCount) {
            Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
            Intrinsics.checkNotNullParameter((Object)((Object)syncState), (String)"syncState");
            return new ReadReceiptSyncJob(channelId, segment, syncState, retryCount);
        }

        public static /* synthetic */ ReadReceiptSyncJob copy$default(ReadReceiptSyncJob readReceiptSyncJob, String string, int n, ReadReceiptSyncState readReceiptSyncState, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = readReceiptSyncJob.channelId;
            }
            if ((n3 & 2) != 0) {
                n = readReceiptSyncJob.segment;
            }
            if ((n3 & 4) != 0) {
                readReceiptSyncState = readReceiptSyncJob.syncState;
            }
            if ((n3 & 8) != 0) {
                n2 = readReceiptSyncJob.retryCount;
            }
            return readReceiptSyncJob.copy(string, n, readReceiptSyncState, n2);
        }

        @NotNull
        public String toString() {
            return "ReadReceiptSyncJob(channelId=" + this.channelId + ", segment=" + this.segment + ", syncState=" + this.syncState + ", retryCount=" + this.retryCount + ")";
        }

        public int hashCode() {
            int result = this.channelId.hashCode();
            result = result * 31 + Integer.hashCode(this.segment);
            result = result * 31 + this.syncState.hashCode();
            result = result * 31 + Integer.hashCode(this.retryCount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReadReceiptSyncJob)) {
                return false;
            }
            ReadReceiptSyncJob readReceiptSyncJob = (ReadReceiptSyncJob)other;
            if (!Intrinsics.areEqual((Object)this.channelId, (Object)readReceiptSyncJob.channelId)) {
                return false;
            }
            if (this.segment != readReceiptSyncJob.segment) {
                return false;
            }
            if (this.syncState != readReceiptSyncJob.syncState) {
                return false;
            }
            return this.retryCount == readReceiptSyncJob.retryCount;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/amity/socialcloud/sdk/core/ChannelReadReceiptSyncEngine$ReadReceiptSyncState;", "", "(Ljava/lang/String;I)V", "CREATED", "SYNCING", "amity-sdk_release"})
    public static final class ReadReceiptSyncState
    extends Enum<ReadReceiptSyncState> {
        public static final /* enum */ ReadReceiptSyncState CREATED = new ReadReceiptSyncState();
        public static final /* enum */ ReadReceiptSyncState SYNCING = new ReadReceiptSyncState();
        private static final /* synthetic */ ReadReceiptSyncState[] $VALUES;

        public static ReadReceiptSyncState[] values() {
            return (ReadReceiptSyncState[])$VALUES.clone();
        }

        public static ReadReceiptSyncState valueOf(String value) {
            return Enum.valueOf(ReadReceiptSyncState.class, value);
        }

        static {
            $VALUES = readReceiptSyncStateArray = new ReadReceiptSyncState[]{ReadReceiptSyncState.CREATED, ReadReceiptSyncState.SYNCING};
        }
    }
}

