package com.amity.socialcloud.sdk.social.domain.story.query

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.api.social.story.AmityStorySortOption
import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.amity.socialcloud.sdk.social.data.story.StoryRepository
import com.amity.socialcloud.sdk.social.domain.story.StoryComposerUseCase
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors


internal class GetActiveStoriesUseCase {

    fun execute(
        targetType: AmityStory.TargetType,
        targetId: String,
        sortOption: AmityStorySortOption
    ): Flowable<PagingData<AmityStory>> {
        return StoryRepository().getActiveStories(
            targetType = targetType,
            targetId = targetId,
            sortOption = sortOption
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { story ->
                StoryComposerUseCase().execute(story)
            }
        }
    }
}