package com.amity.socialcloud.sdk.api.social.post.create.datatype

import com.amity.socialcloud.sdk.model.core.file.AmityFile
import com.amity.socialcloud.sdk.model.core.file.AmityImage
import com.amity.socialcloud.sdk.model.core.file.AmityVideo


abstract class AmityPostCreationDataType(private val targetType: String, private val targetId: String) {

    /**
     * @param [text] to add text value to the post
     * @return new instance of AmityTextPostCreator.Builder
     */
    fun text(text: String): AmityTextPostCreator.Builder {
        return AmityTextPostCreator.Builder()
                .targetType(targetType)
                .targetId(targetId)
                .text(text)
    }

    /**
     * @param [images] to add images as children
     * @return new instance of AmityImagePostCreator.Builder
     */
    fun image(vararg images: AmityImage): AmityImagePostCreator.Builder {
        return AmityImagePostCreator.Builder()
                .targetType(targetType)
                .targetId(targetId)
                .images(*images)
    }

    /**
     * @param [files] to add files as children
     * @return new instance of AmityFilePostCreator.Builder
     */
    fun file(vararg files: AmityFile): AmityFilePostCreator.Builder {
        return AmityFilePostCreator.Builder()
                .targetType(targetType)
                .targetId(targetId)
                .files(*files)
    }

    /**
     * @param [videos] to add videos as children
     * @return new instance of AmityVideoPostCreator.Builder
     */
    fun video(vararg videos: AmityVideo): AmityVideoPostCreator.Builder {
        return AmityVideoPostCreator.Builder()
                .targetType(targetType)
                .targetId(targetId)
                .videos(*videos)
    }

    /**
     * @param [pollId] to add poll as child
     * @return new instance of AmityPollPostCreator.Builder
     */
    fun poll(pollId: String): AmityPollPostCreator.Builder {
        return AmityPollPostCreator.Builder()
            .targetType(targetType)
            .targetId(targetId)
            .pollId(pollId)
    }

    /**
     * @param [streamId] to add stream as child
     * @return new instance of AmityLiveStreamPostCreator.Builder
     */
    fun liveStream(streamId: String): AmityLiveStreamPostCreator.Builder {
        return AmityLiveStreamPostCreator.Builder()
            .targetType(targetType)
            .targetId(targetId)
            .streamId(streamId)
    }
}
