package com.ekoapp.ekosdk.internal.usecase.comment

import com.amity.socialcloud.sdk.model.social.comment.AmityComment
import com.amity.socialcloud.sdk.social.data.comment.CommentRepository
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator
import io.reactivex.rxjava3.core.Flowable

internal class CommentReactorUseCase {

    fun execute(
        referenceId: String,
        referenceType: String,
        parentId: String?,
        isDeleted: Boolean?,
        dynamicQueryStreamKeyCreator: DynamicQueryStreamKeyCreator,
        nonce: Int
    ): Flowable<AmityComment> {
        return CommentRepository()
            .getLatestComment(
                referenceId = referenceId,
                referenceType = referenceType,
                parentId = parentId,
                isDeleted = isDeleted,
                dynamicQueryStreamKeyCreator = dynamicQueryStreamKeyCreator,
                nonce = nonce
            )
    }
}