package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.SubChannelMarkerEntity
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class SubChannelMarkerDao : EkoObjectDao<SubChannelMarkerEntity>() {
	@Query("SELECT * from sub_channel_marker where subChannelId = :subChannelId LIMIT 1")
	abstract fun getById(subChannelId: String): Flowable<SubChannelMarkerEntity>
	
	@Query("SELECT * from sub_channel_marker where subChannelId = :subChannelId LIMIT 1")
	abstract override fun getByIdNow(subChannelId: String): SubChannelMarkerEntity?
	
	@Query("DELETE from sub_channel_marker")
	abstract override fun deleteAll()
	
	@Query("DELETE from sub_channel_marker where subChannelId = :subChannelId")
	abstract fun deleteById(subChannelId: String)
}