package com.amity.socialcloud.sdk.model.chat.message

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityMessagePreview internal constructor (
	private val messagePreviewId: String,
	private val dataType: AmityMessage.DataType,
	private val data: AmityMessage.Data,
	internal val rawData: JsonObject?,
	private val channelId: String,
	private val subChannelId: String,
	private var subChannelName: String,
	private val userId: String,
	internal var user: AmityUser? = null,
	private val isDeleted: Boolean,
	private val segment: Int,
	private val createdAt: DateTime,
	private val updatedAt: DateTime,
): Parcelable {
	fun getUser(): AmityUser? {
		return user
	}
	
	fun getMessagePreviewId(): String {
		return messagePreviewId
	}
	
	fun getDataType(): AmityMessage.DataType {
		return dataType
	}
	
	fun getData(): AmityMessage.Data {
		return data
	}
	
	fun getChannelId(): String {
		return channelId
	}
	
	fun getSubChannelId(): String {
		return subChannelId
	}
	
	fun getSubChannelName(): String {
		return subChannelName
	}
	
	fun getUserId(): String {
		return userId
	}
	
	fun getSegment(): Int {
		return segment
	}
	
	fun isDeleted(): Boolean {
		return isDeleted
	}
	
	fun getCreatedAt(): DateTime {
		return createdAt
	}
	
	fun getUpdatedAt(): DateTime {
		return updatedAt
	}
}