/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.UserSubChannelMarkerEntity;
import com.ekoapp.ekosdk.internal.data.dao.UserSubChannelMarkerDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class UserSubChannelMarkerDao_Impl
extends UserSubChannelMarkerDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<UserSubChannelMarkerEntity> __insertionAdapterOfUserSubChannelMarkerEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<UserSubChannelMarkerEntity> __deletionAdapterOfUserSubChannelMarkerEntity;
    private final EntityDeletionOrUpdateAdapter<UserSubChannelMarkerEntity> __updateAdapterOfUserSubChannelMarkerEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteById;
    private final SharedSQLiteStatement __preparedStmtOfUpdateReadToSegment;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByChannelId;

    public UserSubChannelMarkerDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserSubChannelMarkerEntity = new EntityInsertionAdapter<UserSubChannelMarkerEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `user_sub_channel_marker` (`subChannelId`,`channelId`,`userId`,`unreadCount`,`readToSegment`,`deliveredToSegment`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, UserSubChannelMarkerEntity value) {
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSubChannelId());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                stmt.bindLong(4, (long)value.getUnreadCount());
                stmt.bindLong(5, (long)value.getReadToSegment());
                stmt.bindLong(6, (long)value.getDeliveredToSegment());
                String _tmp = UserSubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp);
                }
                String _tmp_1 = UserSubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_1);
                }
                String _tmp_2 = UserSubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_2);
                }
            }
        };
        this.__deletionAdapterOfUserSubChannelMarkerEntity = new EntityDeletionOrUpdateAdapter<UserSubChannelMarkerEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `user_sub_channel_marker` WHERE `subChannelId` = ? AND `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserSubChannelMarkerEntity value) {
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSubChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
            }
        };
        this.__updateAdapterOfUserSubChannelMarkerEntity = new EntityDeletionOrUpdateAdapter<UserSubChannelMarkerEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `user_sub_channel_marker` SET `subChannelId` = ?,`channelId` = ?,`userId` = ?,`unreadCount` = ?,`readToSegment` = ?,`deliveredToSegment` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `subChannelId` = ? AND `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserSubChannelMarkerEntity value) {
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSubChannelId());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                stmt.bindLong(4, (long)value.getUnreadCount());
                stmt.bindLong(5, (long)value.getReadToSegment());
                stmt.bindLong(6, (long)value.getDeliveredToSegment());
                String _tmp = UserSubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp);
                }
                String _tmp_1 = UserSubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_1);
                }
                String _tmp_2 = UserSubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_2);
                }
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getSubChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getUserId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from user_sub_channel_marker";
                return "DELETE from user_sub_channel_marker";
            }
        };
        this.__preparedStmtOfDeleteById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from user_sub_channel_marker where subChannelId = ?";
                return "DELETE from user_sub_channel_marker where subChannelId = ?";
            }
        };
        this.__preparedStmtOfUpdateReadToSegment = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE user_sub_channel_marker set readToSegment = ? where subChannelId = ? and readToSegment < ?";
                return "UPDATE user_sub_channel_marker set readToSegment = ? where subChannelId = ? and readToSegment < ?";
            }
        };
        this.__preparedStmtOfDeleteByChannelId = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from user_sub_channel_marker where channelId = ?";
                return "DELETE from user_sub_channel_marker where channelId = ?";
            }
        };
    }

    @Override
    public void insertImpl(UserSubChannelMarkerEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfUserSubChannelMarkerEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends UserSubChannelMarkerEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfUserSubChannelMarkerEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(UserSubChannelMarkerEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfUserSubChannelMarkerEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends UserSubChannelMarkerEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfUserSubChannelMarkerEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(UserSubChannelMarkerEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfUserSubChannelMarkerEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(UserSubChannelMarkerEntity object) {
        this.__db.beginTransaction();
        try {
            UserSubChannelMarkerDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends UserSubChannelMarkerEntity> objects) {
        this.__db.beginTransaction();
        try {
            UserSubChannelMarkerDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(UserSubChannelMarkerEntity object) {
        this.__db.beginTransaction();
        try {
            UserSubChannelMarkerDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteById(String subChannelId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteById.acquire();
        int _argIndex = 1;
        if (subChannelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subChannelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteById.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateReadToSegment(String subChannelId, int segment) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateReadToSegment.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)segment);
        _argIndex = 2;
        if (subChannelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subChannelId);
        }
        _argIndex = 3;
        _stmt.bindLong(_argIndex, (long)segment);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateReadToSegment.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByChannelId(String channelId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteByChannelId.acquire();
        int _argIndex = 1;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteByChannelId.release(_stmt);
        }
    }

    @Override
    public Flowable<UserSubChannelMarkerEntity> getById(String subChannelId) {
        String _sql = "SELECT * from user_sub_channel_marker where subChannelId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from user_sub_channel_marker where subChannelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (subChannelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subChannelId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_sub_channel_marker"}, (Callable)new Callable<UserSubChannelMarkerEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UserSubChannelMarkerEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserSubChannelMarkerDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    UserSubChannelMarkerEntity _result;
                    int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfUnreadCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadCount");
                    int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readToSegment");
                    int _cursorIndexOfDeliveredToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deliveredToSegment");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new UserSubChannelMarkerEntity();
                        String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                        _result.setSubChannelId(_tmpSubChannelId);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        int _tmpUnreadCount = _cursor.getInt(_cursorIndexOfUnreadCount);
                        _result.setUnreadCount(_tmpUnreadCount);
                        int _tmpReadToSegment = _cursor.getInt(_cursorIndexOfReadToSegment);
                        _result.setReadToSegment(_tmpReadToSegment);
                        int _tmpDeliveredToSegment = _cursor.getInt(_cursorIndexOfDeliveredToSegment);
                        _result.setDeliveredToSegment(_tmpDeliveredToSegment);
                        String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = UserSubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = UserSubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = UserSubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    UserSubChannelMarkerEntity userSubChannelMarkerEntity = _result;
                    return userSubChannelMarkerEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserSubChannelMarkerEntity getByIdNow(String subChannelId) {
        String _sql = "SELECT * from user_sub_channel_marker where subChannelId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from user_sub_channel_marker where subChannelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (subChannelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subChannelId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            UserSubChannelMarkerEntity _result;
            int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfUnreadCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadCount");
            int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readToSegment");
            int _cursorIndexOfDeliveredToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deliveredToSegment");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new UserSubChannelMarkerEntity();
                String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                _result.setSubChannelId(_tmpSubChannelId);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                int _tmpUnreadCount = _cursor.getInt(_cursorIndexOfUnreadCount);
                _result.setUnreadCount(_tmpUnreadCount);
                int _tmpReadToSegment = _cursor.getInt(_cursorIndexOfReadToSegment);
                _result.setReadToSegment(_tmpReadToSegment);
                int _tmpDeliveredToSegment = _cursor.getInt(_cursorIndexOfDeliveredToSegment);
                _result.setDeliveredToSegment(_tmpDeliveredToSegment);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            UserSubChannelMarkerEntity userSubChannelMarkerEntity = _result;
            return userSubChannelMarkerEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

