/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.session;

import android.util.Log;
import co.amity.rxbridge.CompletableKt;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.data.notification.device.DeviceNotificationRepository;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.core.data.session.SessionRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.session.SessionRepository;
import com.amity.socialcloud.sdk.core.data.user.UserQueryPersister;
import com.amity.socialcloud.sdk.core.data.user.UserRepository;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import com.amity.socialcloud.sdk.model.core.user.UserUpdateOption;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto;
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceDto;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.github.davidmoten.rx2.RetryWhen;
import io.reactivex.functions.Predicate;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\tJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J*\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u000bJ,\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012J,\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/amity/socialcloud/sdk/core/data/session/SessionRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "ABOUT_TO_EXPIRE_TRESHOLD", "", "activateAccount", "Lio/reactivex/rxjava3/core/Single;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "userId", "", "clearData", "Lio/reactivex/rxjava3/core/Completable;", "getActiveUserId", "getCurrentAccount", "login", "displayName", "authToken", "isLegacyVersion", "", "logout", "renewToken", "account", "renewTokenIfNeed", "updateDisplayNameIfNeeded", "", "verifyCurrentAccessToken", "amity-sdk_release"})
public final class SessionRepository
extends EkoObjectRepository {
    private final double ABOUT_TO_EXPIRE_TRESHOLD;

    @NotNull
    public final String getActiveUserId() {
        return new SessionLocalDataStore().getActiveUserId();
    }

    @NotNull
    public final Completable login(@NotNull String userId, @Nullable String displayName, @Nullable String authToken, boolean isLegacyVersion) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = this.activateAccount(userId).flatMapCompletable((Function)new Function<EkoAccount, CompletableSource>(this, displayName, authToken, isLegacyVersion){
            final /* synthetic */ SessionRepository this$0;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authToken;
            final /* synthetic */ boolean $isLegacyVersion;

            public final CompletableSource apply(EkoAccount it) {
                EkoAccount ekoAccount = it;
                Intrinsics.checkNotNullExpressionValue((Object)ekoAccount, (String)"it");
                return (CompletableSource)SessionRepository.access$renewTokenIfNeed(this.this$0, ekoAccount, this.$displayName, this.$authToken, this.$isLegacyVersion);
            }
            {
                this.this$0 = sessionRepository;
                this.$displayName = string;
                this.$authToken = string2;
                this.$isLegacyVersion = bl;
            }
        }).doOnComplete(new Action(this, userId, displayName){
            final /* synthetic */ SessionRepository this$0;
            final /* synthetic */ String $userId;
            final /* synthetic */ String $displayName;

            public final void run() {
                SessionRepository.access$updateDisplayNameIfNeeded(this.this$0, this.$userId, this.$displayName);
            }
            {
                this.this$0 = sessionRepository;
                this.$userId = string;
                this.$displayName = string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"activateAccount(userId)\n\u2026isplayName)\n            }");
        return completable;
    }

    @NotNull
    public final Completable logout() {
        return new DeviceNotificationRepository().unregisterAll();
    }

    @NotNull
    public final Completable clearData() {
        Completable completable = Completable.fromAction((Action)clearData.1.INSTANCE).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026scribeOn(Schedulers.io())");
        return completable;
    }

    @NotNull
    public final Single<EkoAccount> getCurrentAccount() {
        Single single = Single.fromCallable((Callable)getCurrentAccount.1.INSTANCE).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"Single.fromCallable {\n  \u2026scribeOn(Schedulers.io())");
        return single;
    }

    @NotNull
    public final Completable renewToken(@NotNull EkoAccount account, @Nullable String displayName, @Nullable String authToken, boolean isLegacyVersion) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Completable completable = new SessionLocalDataStore().getApiKey().flatMapCompletable((Function)new Function<EkoApiKey, CompletableSource>(this, account, displayName, authToken, isLegacyVersion){
            final /* synthetic */ SessionRepository this$0;
            final /* synthetic */ EkoAccount $account;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authToken;
            final /* synthetic */ boolean $isLegacyVersion;

            public final CompletableSource apply(EkoApiKey it) {
                SessionRemoteDataStore sessionRemoteDataStore = new SessionRemoteDataStore();
                EkoApiKey ekoApiKey = it;
                Intrinsics.checkNotNullExpressionValue((Object)ekoApiKey, (String)"it");
                String string = ekoApiKey.getApiKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.apiKey");
                String string2 = this.$account.getUserId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"account.userId");
                String string3 = this.$account.getDeviceId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"account.deviceId");
                Completable completable = sessionRemoteDataStore.registerDevice(string, string2, this.$displayName, string3, this.$authToken, this.$isLegacyVersion).flatMapCompletable((Function)new Function<RegisterDeviceDto, CompletableSource>(this){
                    final /* synthetic */ renewToken.1 this$0;

                    public final CompletableSource apply(RegisterDeviceDto it) {
                        this.this$0.$account.setRefreshToken(it.getRefreshToken());
                        this.this$0.$account.setAccessToken(it.getAccessToken());
                        if (this.this$0.$isLegacyVersion) {
                            this.this$0.$account.setIssuedAt(DateTime.now());
                            this.this$0.$account.setExpiresAt(DateTime.now().plus((ReadableDuration)Duration.standardDays((long)365L)));
                        } else {
                            this.this$0.$account.setIssuedAt(it.getIssuedAt());
                            this.this$0.$account.setExpiresAt(it.getExpiresAt());
                        }
                        DateTime dateTime = this.this$0.$account.getExpiresAt();
                        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"account.expiresAt");
                        long l = dateTime.getMillis();
                        DateTime dateTime2 = this.this$0.$account.getIssuedAt();
                        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"account.issuedAt");
                        double tokenDuration = (double)(l - dateTime2.getMillis() - (long)CoreClient.INSTANCE.getMillisTimeDiff$amity_sdk_release()) * SessionRepository.access$getABOUT_TO_EXPIRE_TRESHOLD$p(this.this$0.this$0);
                        this.this$0.$account.setAboutToExpireAt(this.this$0.$account.getIssuedAt().plus((long)tokenDuration));
                        Log.e((String)"SSM3", (String)("token renewed: account updated : \n " + "      expiresAt = " + this.this$0.$account.getExpiresAt() + " \naboutToExpireAt = " + this.this$0.$account.getAboutToExpireAt() + '\n' + "       issuedAt = " + this.this$0.$account.getIssuedAt() + "\nduration: = " + tokenDuration / (double)1000 + " sec "));
                        EkoUserListDto ekoUserListDto = new EkoUserListDto();
                        boolean bl = false;
                        boolean bl2 = false;
                        EkoUserListDto $this$apply = ekoUserListDto;
                        boolean bl3 = false;
                        List list2 = it.getUsers();
                        if (list2 == null) {
                            list2 = CollectionsKt.emptyList();
                        }
                        $this$apply.setUsers(list2);
                        List list3 = it.getFiles();
                        if (list3 == null) {
                            list3 = CollectionsKt.emptyList();
                        }
                        $this$apply.setFiles(list3);
                        EkoUserListDto users = ekoUserListDto;
                        return (CompletableSource)new SessionLocalDataStore().updateAccount(this.this$0.$account).andThen((CompletableSource)new UserQueryPersister().persist(users));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"SessionRemoteDataStore()\u2026s))\n                    }");
                io.reactivex.Completable completable2 = CompletableKt.toRx2((Completable)completable).retryWhen(RetryWhen.retryIf((Predicate)renewToken.2.INSTANCE).maxRetries(3).exponentialBackoff(1L, 10L, TimeUnit.SECONDS, 1.5).build()).doOnError((io.reactivex.functions.Consumer)new io.reactivex.functions.Consumer<Throwable>(this){
                    final /* synthetic */ renewToken.1 this$0;

                    public final void accept(Throwable it) {
                        SessionLocalDataStore sessionLocalDataStore = new SessionLocalDataStore();
                        String string = this.this$0.$account.getUserId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"account.userId");
                        sessionLocalDataStore.logoutAccount(string);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"SessionRemoteDataStore()\u2026Id)\n                    }");
                return (CompletableSource)CompletableKt.toRx3((io.reactivex.Completable)completable2);
            }
            {
                this.this$0 = sessionRepository;
                this.$account = ekoAccount;
                this.$displayName = string;
                this.$authToken = string2;
                this.$isLegacyVersion = bl;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"SessionLocalDataStore().\u2026   .toRx3()\n            }");
        return completable;
    }

    public static /* synthetic */ Completable renewToken$default(SessionRepository sessionRepository, EkoAccount ekoAccount, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return sessionRepository.renewToken(ekoAccount, string, string2, bl);
    }

    private final Single<EkoAccount> activateAccount(String userId) {
        Single single = Single.fromCallable((Callable)new Callable<EkoAccount>(userId){
            final /* synthetic */ String $userId;

            public final EkoAccount call() {
                return new SessionLocalDataStore().activateAccount(this.$userId);
            }
            {
                this.$userId = string;
            }
        }).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"Single.fromCallable {\n  \u2026scribeOn(Schedulers.io())");
        return single;
    }

    private final Completable renewTokenIfNeed(EkoAccount account, String displayName, String authToken, boolean isLegacyVersion) {
        Completable completable = this.verifyCurrentAccessToken(account).onErrorResumeNext((Function)new Function<Throwable, CompletableSource>(this, account, displayName, authToken, isLegacyVersion){
            final /* synthetic */ SessionRepository this$0;
            final /* synthetic */ EkoAccount $account;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authToken;
            final /* synthetic */ boolean $isLegacyVersion;

            public final CompletableSource apply(Throwable it) {
                return AmityError.Companion.from(it) == AmityError.USER_IS_GLOBAL_BANNED ? (CompletableSource)Completable.error((Throwable)it) : (CompletableSource)this.this$0.renewToken(this.$account, this.$displayName, this.$authToken, this.$isLegacyVersion);
            }
            {
                this.this$0 = sessionRepository;
                this.$account = ekoAccount;
                this.$displayName = string;
                this.$authToken = string2;
                this.$isLegacyVersion = bl;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"verifyCurrentAccessToken\u2026          }\n            }");
        return completable;
    }

    private final Completable verifyCurrentAccessToken(EkoAccount account) {
        Completable completable = new SessionLocalDataStore().getApiKey().flatMapCompletable((Function)new Function<EkoApiKey, CompletableSource>(account){
            final /* synthetic */ EkoAccount $account;

            public final CompletableSource apply(EkoApiKey it) {
                CompletableSource completableSource;
                if (this.$account.getAccessToken() == null) {
                    completableSource = (CompletableSource)Completable.error((Throwable)AmityException.Companion.create("accessToken not found", null, AmityError.UNAUTHORIZED_ERROR));
                } else {
                    SessionRemoteDataStore sessionRemoteDataStore = new SessionRemoteDataStore();
                    EkoApiKey ekoApiKey = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ekoApiKey, (String)"it");
                    String string = ekoApiKey.getApiKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.apiKey");
                    completableSource = (CompletableSource)sessionRemoteDataStore.verifyAccessToken(string);
                }
                return completableSource;
            }
            {
                this.$account = ekoAccount;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"SessionLocalDataStore().\u2026          }\n            }");
        return completable;
    }

    private final void updateDisplayNameIfNeeded(String userId, String displayName) {
        if (displayName != null) {
            new UserRepository().observe(userId).firstOrError().flatMapCompletable((Function)new Function<AmityUser, CompletableSource>(displayName, userId){
                final /* synthetic */ String $displayName;
                final /* synthetic */ String $userId;

                public final CompletableSource apply(AmityUser it) {
                    return Intrinsics.areEqual((Object)it.getDisplayName(), (Object)this.$displayName) ? (CompletableSource)Completable.complete() : (CompletableSource)new UserRepository().updateUser(this.$userId, new UserUpdateOption(this.$displayName, null, null, null, null, null, null, 126, null)).ignoreElement();
                }
                {
                    this.$displayName = string;
                    this.$userId = string2;
                }
            }).subscribeOn(Schedulers.io()).doOnError((Consumer)updateDisplayNameIfNeeded.2.INSTANCE).subscribe();
        }
    }

    public SessionRepository() {
        this.ABOUT_TO_EXPIRE_TRESHOLD = 0.8;
    }

    public static final /* synthetic */ Completable access$renewTokenIfNeed(SessionRepository $this, EkoAccount account, String displayName, String authToken, boolean isLegacyVersion) {
        return $this.renewTokenIfNeed(account, displayName, authToken, isLegacyVersion);
    }

    public static final /* synthetic */ void access$updateDisplayNameIfNeeded(SessionRepository $this, String userId, String displayName) {
        $this.updateDisplayNameIfNeeded(userId, displayName);
    }

    public static final /* synthetic */ double access$getABOUT_TO_EXPIRE_TRESHOLD$p(SessionRepository $this) {
        return $this.ABOUT_TO_EXPIRE_TRESHOLD;
    }
}

