package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import com.ekoapp.ekosdk.internal.data.model.AmityUploadUrl
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.core.Maybe

@Dao
abstract class AmityUploadUrlDao {
    @Query("SELECT * from upload_url LIMIT 1")
    abstract fun observeCurrentUploadUrl(): Flowable<AmityUploadUrl>

    @get:Query("SELECT * from upload_url LIMIT 1")
    abstract val currentUploadUrl: Maybe<AmityUploadUrl>

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    abstract fun insert(url: AmityUploadUrl)
}