package com.amity.socialcloud.sdk.social.data.storytarget

import com.amity.socialcloud.sdk.dto.social.story.StoryQueryDto
import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import io.reactivex.rxjava3.core.Single

class StoryTargetRemoteDataStore {

    fun getStoryTarget(targetType: String, targetId: String): Single<StoryQueryDto> {
        return Single.fromCallable {
            mapOf(
                "targets[0][targetType]" to targetType,
                "targets[0][targetId]" to targetId,
            )
        }.flatMap { map ->
            AmityHttpClient.get(StoryTargetApi::class).flatMap {
                it.queryStoryTargets(map)
            }
        }

    }

    fun getStoryTargets(targets: List<Pair<AmityStory.TargetType, String>>): Single<StoryQueryDto> {
        return Single.fromCallable {
            mutableMapOf<String,String>().apply {
                targets.forEach {
                    put("targets[${targets.indexOf(it)}][targetType]", it.first.apiKey)
                    put("targets[${targets.indexOf(it)}][targetId]", it.second)
                }
            }
        }.flatMap { map ->
            AmityHttpClient.get(StoryTargetApi::class).flatMap {
                it.queryStoryTargets(map)
            }
        }

    }

    fun getGlobalFeed(
        seenState: String,
        limit: Int? = null,
        token: String? = null
    ): Single<StoryQueryDto> {
        return AmityHttpClient.get(StoryTargetApi::class).flatMap {
            it.queryGlobalFeed(
                seenState = seenState,
                limit = limit,
                token = token
            )
        }
    }

}