package com.amity.socialcloud.sdk.model.core.ad

import android.os.Parcelable
import com.amity.socialcloud.sdk.model.core.file.AmityImage
import kotlinx.parcelize.Parcelize
import org.joda.time.DateTime

@Parcelize
data class AmityAdvertiser(
    private val advertiserId: String,
    private val name: String,
    private val companyName: String,
    internal val avatarFileId: String?,
    internal var avatar: AmityImage? = null,
    private val createdAt: DateTime,
    private val updatedAt: DateTime,
): Parcelable {

    fun getAdvertiserId(): String {
        return advertiserId
    }

    fun getName(): String {
        return name
    }

    fun getCompanyName(): String {
        return companyName
    }

    fun getAvatar(): AmityImage? {
        return avatar
    }

    fun getCreatedAt(): DateTime {
        return createdAt
    }

    fun getUpdatedAt(): DateTime {
        return updatedAt
    }
}