/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.model.core.unread.Unread;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.ChannelUnreadEntity;
import com.ekoapp.ekosdk.internal.data.dao.ChannelUnreadDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class ChannelUnreadDao_Impl
extends ChannelUnreadDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChannelUnreadEntity> __insertionAdapterOfChannelUnreadEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<ChannelUnreadEntity> __deletionAdapterOfChannelUnreadEntity;
    private final EntityDeletionOrUpdateAdapter<ChannelUnreadEntity> __updateAdapterOfChannelUnreadEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteById;

    public ChannelUnreadDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfChannelUnreadEntity = new EntityInsertionAdapter<ChannelUnreadEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `channel_unread` (`channelId`,`unreadCount`,`isMentioned`,`readToSegment`,`lastSegment`,`lastMentionedSegment`,`isDeleted`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelUnreadEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                stmt.bindLong(2, (long)value.getUnreadCount());
                int _tmp = value.isMentioned() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                if (value.getReadToSegment() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, (long)value.getReadToSegment().intValue());
                }
                stmt.bindLong(5, (long)value.getLastSegment());
                if (value.getLastMentionedSegment() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, (long)value.getLastMentionedSegment().intValue());
                }
                int _tmp_1 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_1);
                String _tmp_2 = ChannelUnreadDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_2);
                }
                String _tmp_3 = ChannelUnreadDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_3);
                }
                String _tmp_4 = ChannelUnreadDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_4);
                }
            }
        };
        this.__deletionAdapterOfChannelUnreadEntity = new EntityDeletionOrUpdateAdapter<ChannelUnreadEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `channel_unread` WHERE `channelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelUnreadEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
            }
        };
        this.__updateAdapterOfChannelUnreadEntity = new EntityDeletionOrUpdateAdapter<ChannelUnreadEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `channel_unread` SET `channelId` = ?,`unreadCount` = ?,`isMentioned` = ?,`readToSegment` = ?,`lastSegment` = ?,`lastMentionedSegment` = ?,`isDeleted` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `channelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelUnreadEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                stmt.bindLong(2, (long)value.getUnreadCount());
                int _tmp = value.isMentioned() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                if (value.getReadToSegment() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, (long)value.getReadToSegment().intValue());
                }
                stmt.bindLong(5, (long)value.getLastSegment());
                if (value.getLastMentionedSegment() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, (long)value.getLastMentionedSegment().intValue());
                }
                int _tmp_1 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_1);
                String _tmp_2 = ChannelUnreadDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_2);
                }
                String _tmp_3 = ChannelUnreadDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_3);
                }
                String _tmp_4 = ChannelUnreadDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_4);
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getChannelId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from channel_unread";
                return "DELETE from channel_unread";
            }
        };
        this.__preparedStmtOfDeleteById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from channel_unread where channelId = ?";
                return "DELETE from channel_unread where channelId = ?";
            }
        };
    }

    @Override
    public void insertImpl(ChannelUnreadEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfChannelUnreadEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends ChannelUnreadEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfChannelUnreadEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(ChannelUnreadEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfChannelUnreadEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends ChannelUnreadEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfChannelUnreadEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(ChannelUnreadEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfChannelUnreadEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(ChannelUnreadEntity object) {
        this.__db.beginTransaction();
        try {
            ChannelUnreadDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends ChannelUnreadEntity> objects) {
        this.__db.beginTransaction();
        try {
            ChannelUnreadDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(ChannelUnreadEntity object) {
        this.__db.beginTransaction();
        try {
            ChannelUnreadDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteById(String channelId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteById.acquire();
        int _argIndex = 1;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteById.release(_stmt);
        }
    }

    @Override
    public Flowable<ChannelUnreadEntity> getById(String channelId) {
        String _sql = "SELECT * from channel_unread where channelId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from channel_unread where channelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel_unread"}, (Callable)new Callable<ChannelUnreadEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ChannelUnreadEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ChannelUnreadDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ChannelUnreadEntity _result;
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfUnreadCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadCount");
                    int _cursorIndexOfIsMentioned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isMentioned");
                    int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readToSegment");
                    int _cursorIndexOfLastSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastSegment");
                    int _cursorIndexOfLastMentionedSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMentionedSegment");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new ChannelUnreadEntity();
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        int _tmpUnreadCount = _cursor.getInt(_cursorIndexOfUnreadCount);
                        _result.setUnreadCount(_tmpUnreadCount);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsMentioned);
                        boolean _tmpIsMentioned = _tmp != 0;
                        _result.setMentioned(_tmpIsMentioned);
                        Integer _tmpReadToSegment = _cursor.isNull(_cursorIndexOfReadToSegment) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfReadToSegment));
                        _result.setReadToSegment(_tmpReadToSegment);
                        int _tmpLastSegment = _cursor.getInt(_cursorIndexOfLastSegment);
                        _result.setLastSegment(_tmpLastSegment);
                        Integer _tmpLastMentionedSegment = _cursor.isNull(_cursorIndexOfLastMentionedSegment) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfLastMentionedSegment));
                        _result.setLastMentionedSegment(_tmpLastMentionedSegment);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_1 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = ChannelUnreadDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = ChannelUnreadDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = ChannelUnreadDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    ChannelUnreadEntity channelUnreadEntity = _result;
                    return channelUnreadEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelUnreadEntity getByChannelIdNow(String channelId) {
        String _sql = "SELECT * from channel_unread where channelId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from channel_unread where channelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ChannelUnreadEntity _result;
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfUnreadCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadCount");
            int _cursorIndexOfIsMentioned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isMentioned");
            int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readToSegment");
            int _cursorIndexOfLastSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastSegment");
            int _cursorIndexOfLastMentionedSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMentionedSegment");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new ChannelUnreadEntity();
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                int _tmpUnreadCount = _cursor.getInt(_cursorIndexOfUnreadCount);
                _result.setUnreadCount(_tmpUnreadCount);
                int _tmp = _cursor.getInt(_cursorIndexOfIsMentioned);
                boolean _tmpIsMentioned = _tmp != 0;
                _result.setMentioned(_tmpIsMentioned);
                Integer _tmpReadToSegment = _cursor.isNull(_cursorIndexOfReadToSegment) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfReadToSegment));
                _result.setReadToSegment(_tmpReadToSegment);
                int _tmpLastSegment = _cursor.getInt(_cursorIndexOfLastSegment);
                _result.setLastSegment(_tmpLastSegment);
                Integer _tmpLastMentionedSegment = _cursor.isNull(_cursorIndexOfLastMentionedSegment) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfLastMentionedSegment));
                _result.setLastMentionedSegment(_tmpLastMentionedSegment);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_1 != 0;
                _result.setDeleted(_tmpIsDeleted);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            ChannelUnreadEntity channelUnreadEntity = _result;
            return channelUnreadEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<Unread> getTotalChannelsUnread() {
        String _sql = "SELECT COALESCE(SUM(channel_unread.unreadCount), 0) as unreadCount, COALESCE(MAX(channel_unread.isMentioned), 0) as isMentioned from channel_unread where channel_unread.channelId in (SELECT channelId from channel)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COALESCE(SUM(channel_unread.unreadCount), 0) as unreadCount, COALESCE(MAX(channel_unread.isMentioned), 0) as isMentioned from channel_unread where channel_unread.channelId in (SELECT channelId from channel)", (int)0);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel_unread", "channel"}, (Callable)new Callable<Unread>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unread call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ChannelUnreadDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Unread _result;
                    boolean _cursorIndexOfUnreadCount = false;
                    boolean _cursorIndexOfIsMentioned = true;
                    if (_cursor.moveToFirst()) {
                        int _tmpUnreadCount = _cursor.getInt(0);
                        int _tmp = _cursor.getInt(1);
                        boolean _tmpIsMentioned = _tmp != 0;
                        _result = new Unread(_tmpUnreadCount, _tmpIsMentioned);
                    } else {
                        _result = null;
                    }
                    Unread unread = _result;
                    return unread;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

