package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Query;

import com.ekoapp.ekosdk.internal.data.model.EkoUserFlag;

import io.reactivex.rxjava3.core.Flowable;

@Dao
public abstract class EkoUserFlagDao extends EkoObjectDao<EkoUserFlag> {

    @Query("DELETE from user_flag")
    public abstract void deleteAll();

    @Query("SELECT * from user_flag where userId = :userId LIMIT 1")
    abstract EkoUserFlag getByIdNowImpl(String userId);

    public EkoUserFlag getByIdNow(String userId) {
        return getByIdNowImpl(userId);
    }

    @Query("SELECT * from user_flag where userId = :userId LIMIT 1")
    abstract Flowable<EkoUserFlag> getByIdImpl(String userId);

    public Flowable<EkoUserFlag> getById(String userId) {
        return getByIdImpl(userId);
    }



}
