package com.ekoapp.ekosdk.internal.api.http

import android.net.Uri
import com.ekoapp.ekosdk.internal.api.EkoEndpoint.getHttpUrl
import com.ekoapp.ekosdk.internal.api.EkoEndpoint.getUploadUrl
import com.ekoapp.ekosdk.internal.data.EkoDatabase
import okhttp3.Interceptor
import okhttp3.Request
import okhttp3.Response
import java.io.IOException


class AmityAuthenticationInterceptor internal constructor() : Interceptor {

    @Throws(IOException::class)
    override fun intercept(chain: Interceptor.Chain): Response {
        val originalRequest = chain.request()
        val account = EkoDatabase.get()
            .accountDao()
            .currentAccountNow
        val hosts = listOf(Uri.parse(getHttpUrl()).host, Uri.parse(getUploadUrl()).host)
        val request: Request =
            if (hosts.contains(originalRequest.url.host)) {
                val builder = chain.request().newBuilder()
                builder.header("Authorization", String.format("Bearer %s", account?.accessToken ?: ""))
                builder.build()
            } else {
                originalRequest
            }
        return chain.proceed(request)
    }

}
