package com.amity.socialcloud.sdk.api.core.follow.query

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowRelationship
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatusFilter
import com.ekoapp.ekosdk.internal.usecase.user.GetMyFollowingsPagingDataUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityMyFollowingsQuery private constructor(private val status: AmityFollowStatusFilter) {

    fun query(): Flowable<PagingData<AmityFollowRelationship>> {
        return GetMyFollowingsPagingDataUseCase().execute(status = status)
    }

    class Builder internal constructor() {
        private var status: AmityFollowStatusFilter = AmityFollowStatusFilter.ALL

        fun status(status: AmityFollowStatusFilter): Builder {
            this.status = status
            return this
        }

        fun build(): AmityMyFollowingsQuery {
            return AmityMyFollowingsQuery(status)
        }
    }

}