/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.ChannelMarkerEntity;
import com.ekoapp.ekosdk.internal.data.dao.ChannelMarkerDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class ChannelMarkerDao_Impl
extends ChannelMarkerDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChannelMarkerEntity> __insertionAdapterOfChannelMarkerEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<ChannelMarkerEntity> __deletionAdapterOfChannelMarkerEntity;
    private final EntityDeletionOrUpdateAdapter<ChannelMarkerEntity> __updateAdapterOfChannelMarkerEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteById;

    public ChannelMarkerDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfChannelMarkerEntity = new EntityInsertionAdapter<ChannelMarkerEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `channel_marker` (`channelId`,`userId`,`unreadCount`,`isDeleted`,`hasMentioned`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelMarkerEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
                stmt.bindLong(3, (long)value.getUnreadCount());
                int _tmp = value.isDeleted() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp);
                int _tmp_1 = value.getHasMentioned() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                String _tmp_2 = ChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                String _tmp_3 = ChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
                String _tmp_4 = ChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_4);
                }
            }
        };
        this.__deletionAdapterOfChannelMarkerEntity = new EntityDeletionOrUpdateAdapter<ChannelMarkerEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `channel_marker` WHERE `channelId` = ? AND `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelMarkerEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
            }
        };
        this.__updateAdapterOfChannelMarkerEntity = new EntityDeletionOrUpdateAdapter<ChannelMarkerEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `channel_marker` SET `channelId` = ?,`userId` = ?,`unreadCount` = ?,`isDeleted` = ?,`hasMentioned` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `channelId` = ? AND `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelMarkerEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
                stmt.bindLong(3, (long)value.getUnreadCount());
                int _tmp = value.isDeleted() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp);
                int _tmp_1 = value.getHasMentioned() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                String _tmp_2 = ChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                String _tmp_3 = ChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
                String _tmp_4 = ChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_4);
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getUserId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from channel_marker";
                return "DELETE from channel_marker";
            }
        };
        this.__preparedStmtOfDeleteById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from channel_marker where channelId = ?";
                return "DELETE from channel_marker where channelId = ?";
            }
        };
    }

    @Override
    public void insertImpl(ChannelMarkerEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfChannelMarkerEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends ChannelMarkerEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfChannelMarkerEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(ChannelMarkerEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfChannelMarkerEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends ChannelMarkerEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfChannelMarkerEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(ChannelMarkerEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfChannelMarkerEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(ChannelMarkerEntity object) {
        this.__db.beginTransaction();
        try {
            ChannelMarkerDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends ChannelMarkerEntity> objects) {
        this.__db.beginTransaction();
        try {
            ChannelMarkerDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(ChannelMarkerEntity object) {
        this.__db.beginTransaction();
        try {
            ChannelMarkerDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteById(String channelId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteById.acquire();
        int _argIndex = 1;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteById.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelMarkerEntity getByIdNow(String channelId) {
        String _sql = "SELECT * from channel_marker where channelId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from channel_marker where channelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ChannelMarkerEntity _result;
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfUnreadCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadCount");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfHasMentioned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hasMentioned");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new ChannelMarkerEntity();
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                int _tmpUnreadCount = _cursor.getInt(_cursorIndexOfUnreadCount);
                _result.setUnreadCount(_tmpUnreadCount);
                int _tmp = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp != 0;
                _result.setDeleted(_tmpIsDeleted);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfHasMentioned);
                boolean _tmpHasMentioned = _tmp_1 != 0;
                _result.setHasMentioned(_tmpHasMentioned);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            ChannelMarkerEntity channelMarkerEntity = _result;
            return channelMarkerEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<ChannelMarkerEntity> getById(String channelId) {
        String _sql = "SELECT * from channel_marker where channelId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from channel_marker where channelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel_marker"}, (Callable)new Callable<ChannelMarkerEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ChannelMarkerEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ChannelMarkerDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ChannelMarkerEntity _result;
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfUnreadCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unreadCount");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfHasMentioned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hasMentioned");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new ChannelMarkerEntity();
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        int _tmpUnreadCount = _cursor.getInt(_cursorIndexOfUnreadCount);
                        _result.setUnreadCount(_tmpUnreadCount);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfHasMentioned);
                        boolean _tmpHasMentioned = _tmp_1 != 0;
                        _result.setHasMentioned(_tmpHasMentioned);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = ChannelMarkerDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = ChannelMarkerDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = ChannelMarkerDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    ChannelMarkerEntity channelMarkerEntity = _result;
                    return channelMarkerEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

