package com.amity.socialcloud.sdk.model.core.presence

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.core.presence.PresenceConfig
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityUserPresence constructor(
    private val userId: String,
    private val lastHeartbeat: DateTime?
) : Parcelable {

    fun getUserId(): String {
        return userId
    }

    fun getLastHeartbeat(): DateTime? {
        return lastHeartbeat
    }

    fun isOnline(): Boolean {
        return lastHeartbeat?.plusSeconds(PresenceConfig.ONLINE_THRESHOLD)?.isAfterNow == true
    }
}