package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.core.CoreClient
import com.amity.socialcloud.sdk.core.MarkerEvent
import com.amity.socialcloud.sdk.core.ObjectResolverEngine
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus
import com.ekoapp.ekosdk.internal.api.dto.ChannelEventDto
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelMembershipDto
import io.reactivex.rxjava3.core.Completable

internal class ChannelCreated : ChannelEventListener() {

    override fun processEvent(dto: ChannelEventDto) {
        val myUserId = SessionLocalDataStore().getActiveUserId()
        val hasMyMembership = dto.channelMembershipDtoList.find { it.userId == myUserId } != null
        if(!hasMyMembership) {
            val memberships = dto.channelMembershipDtoList
            val myMembership = EkoChannelMembershipDto().apply {
                this.channelId = dto.channelDtoList.first()?.channelId
                this.userId = myUserId
                this.membership = "member"
            }
            val savingMemberships = mutableListOf(myMembership).apply {
                this.addAll(memberships)
            }
            dto.channelMembershipDtoList = savingMemberships

        }
        super.processEvent(dto)
        MarkerEventBus.publish(MarkerEvent.MarkerUpdated(getEventName()))
        dto.channelDtoList
            .map { it.channelId }
            .let {
                CoreClient.resolve(it, ObjectResolverEngine.Companion.ReferenceType.CHANNEL_UNREAD_INFO)
            }
    }

    override fun getEventName(): String {
        return "channel.created"
    }

    override fun shouldProcessEvent(dto: ChannelEventDto): Boolean {
         return true
    }

}