package com.amity.socialcloud.sdk.core.domain.ad.markclick

import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsRepository
import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsService
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventContentType
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventSyncPriority
import com.amity.socialcloud.sdk.model.core.ad.AmityAd
import com.amity.socialcloud.sdk.model.core.ad.AmityAdPlacement
import com.google.gson.JsonObject

internal class MarkAdAsClickUseCase {

    fun execute(ad: AmityAd, adPlacement: AmityAdPlacement) {
        val metadata = JsonObject().apply {
            addProperty("placement", adPlacement.value)
        }
        val event = AnalyticsRepository().createAnalyticEvent(
            contentId = ad.getAdId(),
            contentType = AnalyticsEventContentType.AD,
            activityType = "linkClicked",
            syncPriority = AnalyticsEventSyncPriority.LOW,
            deduplicationKey = ad.getAdId() + ".linkClicked." + adPlacement,
            metadata = metadata
        )
        AnalyticsService().captureEvent(event)
    }
}