package com.amity.socialcloud.sdk.social.data.post.paging

import com.amity.socialcloud.sdk.model.social.feed.AmityFeedType
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepositoryHelper
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator

class CommunityPostKeyCreator(
    private val communityId: String,
    private val sortBy: String,
    private val isDeleted: Boolean?,
    private val feedType: AmityFeedType,
    private val postTypes: List<AmityPost.DataType>
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "targetId" to communityId,
            "targetType" to AmityPost.TargetType.COMMUNITY.apiKey,
            "sortBy" to sortBy,
            "isDeleted" to (isDeleted ?: false),
            "feedType" to feedType.apiKey,
            "postTypes" to PostRepositoryHelper.convertPostTypesToString(postTypes)
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(
            communityId = communityId,
            feedType = feedType.apiKey,
            includeDeleted = isDeleted,
            postTypes = postTypes
        )
    }

    private fun getConditionStatement(
        communityId: String,
        feedType: String,
        includeDeleted: Boolean?,
        postTypes: List<AmityPost.DataType>
    ): String {
        //communityId filter
        val communityFilterStatement =
            "post.targetType = '${AmityPost.TargetType.COMMUNITY.apiKey}'" +
                    " and post.targetId = '$communityId'"

        //feedType filter
        val feedTypeFilterStatement = " and post.feedType = '$feedType'"

        //includeDelete filter
        var isDeletedFilterStatement = ""
        if (includeDeleted == false) {
            isDeletedFilterStatement = " and post.isDeleted = 0"
        } else if (includeDeleted == true) {
            isDeletedFilterStatement = " and post.isDeleted = 1"
        }
        //post types filter
        var postTypesFilterStatement = ""
        if (postTypes.isNotEmpty()) {
            postTypesFilterStatement =
                " and post.postDataType IN (${getPostTypesAsArrayString(postTypes)})"
        }
        //parentPost filter
        val parentPostFilter = if (postTypes.isNullOrEmpty()) {
            " and post.parentPostId is null"
        } else {
            " and post.targetId is not null"
        }

        //compose all condition
        return communityFilterStatement +
                feedTypeFilterStatement +
                isDeletedFilterStatement +
                postTypesFilterStatement +
                parentPostFilter
    }

    private fun getPostTypesAsArrayString(postTypes: List<AmityPost.DataType>): String {
        val typesString = StringBuilder()
        postTypes.forEachIndexed { index, dataType ->
            if (index == 0) {
                typesString.append("'${dataType.getApiKey()}'")
            } else {
                typesString.append(", '${dataType.getApiKey()}'")
            }
        }
        return typesString.toString()
    }
}