package com.ekoapp.ekosdk.internal.api.dto

import com.ekoapp.ekosdk.internal.data.model.EkoMessageQueryToken
import com.google.gson.annotations.SerializedName

data class MessageQueryDto (
	@SerializedName("messages")
	var messages: List<EkoMessageDto> = emptyList(),
	
	@SerializedName("users")
	var users: List<EkoUserDto> = emptyList(),
	
	@SerializedName("files")
	var files: List<EkoFileDto> = emptyList(),
	
	@SerializedName("reactions")
	val reactions: List<EkoReactorDto> = emptyList(),
	
	@SerializedName("paging")
	val token: EkoMessageQueryToken = EkoMessageQueryToken(),
	
	@SerializedName("messageFeeds")
	val subChannels: List<SubChannelDto> = emptyList(),
)