package com.amity.socialcloud.sdk.social.domain.story

import com.amity.socialcloud.sdk.common.AmityObjectRepository
import com.amity.socialcloud.sdk.entity.social.story.StoryEntity
import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.amity.socialcloud.sdk.social.data.story.StoryRepository
import com.ekoapp.ekosdk.internal.TombstoneModelType
import com.ekoapp.ekosdk.internal.usecase.LiveObjectUseCase


internal class StoryLiveObjectUseCase : LiveObjectUseCase<StoryEntity, AmityStory>() {


    override fun createRepository(): AmityObjectRepository<StoryEntity, AmityStory> =
        StoryRepository()

    override fun composeModel(model: AmityStory): AmityStory =
        StoryComposerUseCase().execute(model)

    override fun tombstoneModelType(): TombstoneModelType = TombstoneModelType.STORY
}