package com.amity.socialcloud.sdk.social.data.post.flag

import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.data.model.EkoPostFlag
import io.reactivex.rxjava3.core.Completable

internal class PostFlagLocalDataStore {

    fun saveFlags(flags: List<EkoPostFlag>): Completable {
        return Completable.fromAction {
            val dao = UserDatabase.get().postFlagDao()
            flags.forEach {
                dao.getByIdNow(it.postId)?.let { flag ->
                    it.localFlag = flag.localFlag
                }
            }
            dao.save(flags)
        }
    }

}