/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Query;
import com.amity.socialcloud.sdk.model.social.feed.AmityFeedType;
import com.ekoapp.ekosdk.internal.PostEntity;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@Dao
public abstract class PostDao
extends EkoObjectDao<PostEntity> {
    @Override
    @Delete
    public abstract void delete(PostEntity var1);

    @Override
    @Query(value="DELETE from post")
    public abstract void deleteAll();

    @Query(value="DELETE from post where parentPostId = :postId or postId = :postId")
    public abstract Completable deleteById(String var1);

    @Query(value="UPDATE post set commentCount = commentCount + 1 where postId = :postId")
    public abstract void incrementCommentCount(String var1);

    @Query(value="UPDATE post set commentCount = commentCount - 1 where postId = :postId")
    public abstract void decrementCommentCount(String var1);

    @Query(value="UPDATE post set postId = postId where postId = :postId")
    public abstract void updatePost(String var1);

    @Query(value="SELECT * from post where post.postId IN (:postIds)")
    abstract List<PostEntity> getByIdsNowImpl(List<String> var1);

    @Override
    public List<PostEntity> getByIdsNow(List<String> postIds) {
        return this.getByIdsNowImpl(postIds);
    }

    @Query(value="SELECT * from post where post.postId IN (:postIds) LIMIT 1")
    abstract PostEntity getByIdNowImpl(String var1);

    @Override
    public PostEntity getByIdNow(String postId) {
        return this.getByIdNowImpl(postId);
    }

    @Query(value="SELECT * from post, amity_paging_id where post.targetType = :targetType and post.targetId = :targetId  and post.isDeleted = (case when :includeDeleted is null then post.isDeleted else :includeDeleted end) and post.feedType = (case when :feedType is null then post.feedType else :feedType end) and post.postDataType in (:postTypes)  and post.updatedAt > :now and post.postId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (:hash) and amity_paging_id.nonce = (:nonce) ) order by post.updatedAt  desc limit 1")
    abstract Flowable<PostEntity> getLatestChildrenPostImpl(String var1, String var2, List<String> var3, int var4, int var5, DateTime var6, @Nullable Boolean var7, @Nullable String var8);

    @Query(value="SELECT * from post where post.targetType = :targetType and post.targetId = :targetId  and post.parentPostId is null and post.isDeleted = (case when :includeDeleted is null then post.isDeleted else :includeDeleted end) and post.feedType = (case when :feedType is null then post.feedType else :feedType end) and post.updatedAt > :now and post.postId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (:hash) and amity_paging_id.nonce = (:nonce) ) order by post.updatedAt  desc limit 1")
    abstract Flowable<PostEntity> getLatestParentPostImpl(String var1, String var2, int var3, int var4, DateTime var5, @Nullable Boolean var6, @Nullable String var7);

    public Flowable<PostEntity> getLatestPost(String targetId, String targetType, Boolean includeDeleted, List<String> postTypes, int hash, int nonce, @Nullable AmityFeedType feedType) {
        String feedTypeKey;
        String string = feedTypeKey = feedType != null ? feedType.getApiKey() : null;
        if (postTypes == null || postTypes.isEmpty()) {
            return this.getLatestParentPostImpl(targetId, targetType, hash, nonce, DateTime.now(), includeDeleted, feedTypeKey);
        }
        return this.getLatestChildrenPostImpl(targetId, targetType, postTypes, hash, nonce, DateTime.now(), includeDeleted, feedTypeKey);
    }

    @Query(value="UPDATE post SET isDeleted = :isDeleted WHERE postId LIKE :postId ")
    abstract Completable updateDeletedImpl(String var1, boolean var2);

    public Completable softDeleteById(String postId) {
        return this.updateDeletedImpl(postId, true);
    }

    @Query(value="UPDATE post SET feedType = :feedType WHERE postId = :postId ")
    abstract void updateFeedTypeImpl(String var1, String var2);

    public void updateFeedType(String postId, String feedType) {
        this.updateFeedTypeImpl(postId, feedType);
    }

    @Query(value="SELECT * from post where post.postId IN (:postIds) LIMIT 1")
    abstract Flowable<PostEntity> getPostImpl(String var1);

    public Flowable<PostEntity> getPost(String postId) {
        return this.getPostImpl(postId);
    }

    @Query(value="SELECT * from post where post.postId IN (:postId)")
    abstract Flowable<List<PostEntity>> observePostImpl(String var1);

    public Flowable<List<PostEntity>> observePost(String postId) {
        return this.observePostImpl(postId);
    }
}

