package com.amity.socialcloud.sdk.model.core.ad

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject, JsonObjectParceler>
data class AmityAdsSettings(
    private val isEnabled: Boolean,
    private val maxActiveAds: Int,
    private val frequency: JsonObject,
    private val updatedAt: DateTime
): Parcelable {

    fun isEnabled(): Boolean {
        return isEnabled
    }

    fun getMaxActiveAds(): Int {
        return maxActiveAds
    }

    fun getFrequency(): AmityFrequencySettings {
        return AmityFrequencySettings(frequency)
    }

    fun getUpdatedAt(): DateTime {
        return updatedAt
    }

}