package com.amity.socialcloud.sdk.core.data.settings.network.social

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.settings.network.NetworkSettingsLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.SocialSettingsDto
import io.reactivex.rxjava3.core.Completable


internal class SocialSettingsQueryPersister : QueryPersister<SocialSettingsDto>() {

    override fun persist(dto: SocialSettingsDto): Completable {
        return NetworkSettingsLocalDataStore().saveSocialSettings(
            SocialSettingsEntityMapper().map(listOf(dto))
        )
    }
}