package com.amity.socialcloud.sdk.chat.data.message

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.core.session.SessionError
import com.amity.socialcloud.sdk.core.session.model.SessionState
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.CreateMessageRequest
import com.ekoapp.ekosdk.internal.api.socket.request.MessageUpdateDataRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class MessageRemoteDataStore {

    fun createMessage(
        messageId: String,
        parentId: String?,
        subChannelId: String,
        fileId: String?,
        type: String,
        data: JsonObject,
        tags: AmityTags,
        metadata: JsonObject?,
        mentionees: List<AmityMentioneeTarget>?
    ): Single<MessageQueryDto> {
        val request = CreateMessageRequest(
            messageId,
            messageId,
            subChannelId,
            parentId,
            fileId,
            type,
            data,
            tags,
            metadata,
            mentionees
        )
        val currentSessionState = AmityCoreClient.getCurrentSessionState()
        if (currentSessionState != SessionState.Established) {
            return Single.error(SessionError.fromState(currentSessionState))
        }
        return AmityHttpClient.get(MessageApi::class).flatMap {
            it.createMessage(request)
        }
    }

    fun updateMessage(
        messageId: String,
        data: JsonObject?,
        tags: AmityTags?,
        metadata: JsonObject?,
        mentionees: List<AmityMentioneeTarget>?
    ): Single<MessageQueryDto> {
        val request = MessageUpdateDataRequest(data, tags, metadata, mentionees)
        return AmityHttpClient.get(MessageApi::class).flatMap {
            it.updateMessage(messageId, request)
        }
    }

    fun deleteMessage(messageId: String): Single<MessageQueryDto> {
        return AmityHttpClient.get(MessageApi::class).flatMap {
            it.deleteMessage(messageId)
        }
    }

    fun getMessage(messageId: String): Single<MessageQueryDto> {
        return AmityHttpClient.get(MessageApi::class).flatMap {
            it.getMessage(messageId)
        }
    }

    fun queryMessages(
        subChannelId: String,
        filterByParentId: Boolean? = null,
        parentId: String? = null,
        isDeleted: Boolean? = null,
        includingTags: AmityTags? = null,
        excludingTags: AmityTags? = null,
        dataType: String? = null,
        aroundMessageId: String? = null,
        limit: Int? = null,
        sortBy: String? = null,
        token: String? = null
    ): Single<MessageQueryDto> {
        return AmityHttpClient.get(MessageApi::class).flatMap {
            it.queryMessages(
                subChannelId = subChannelId,
                filterByParentId = filterByParentId,
                parentId = parentId,
                isDeleted = isDeleted,
                tags = includingTags,
                excludeTags = excludingTags,
                dataType = dataType,
                around = aroundMessageId.takeIf { token == null },
                limit = limit,
                sortBy = sortBy.takeIf { aroundMessageId == null },
                token = token
            )
        }
    }

}