package com.amity.socialcloud.sdk.chat.data.marker.message

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.MessageMarkerEntity
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto
import org.joda.time.DateTime

internal class MessageMarkerEntityOptimisticMapper : EntityMapper<EkoMessageDto, MessageMarkerEntity>() {

    override fun map(list: List<EkoMessageDto>): List<MessageMarkerEntity> {
        return list.map { map(it) }
    }

    fun map(dto: EkoMessageDto) : MessageMarkerEntity {
        return MessageMarkerEntity().apply {
            messageId = dto.messageId
            subChannelId = dto.subChannelId
            readCount = 0
            deliveredCount = 0
            createdAt = dto.createdAt - 1 ?: DateTime.now()
            updatedAt = dto.updatedAt - 1 ?: DateTime.now()
        }
    }

}