package com.amity.socialcloud.sdk.chat.data.marker.message

import com.amity.socialcloud.sdk.chat.data.marker.readuser.MessageDeliveredUsersRequest
import com.amity.socialcloud.sdk.chat.data.marker.readuser.MessageReadUsersRequest
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.MessageDeliveredUsersQueryDto
import com.ekoapp.ekosdk.internal.api.dto.MessageMarkerQueryDto
import com.ekoapp.ekosdk.internal.api.dto.MessageReadUsersQueryDto
import io.reactivex.rxjava3.core.Single

internal class MessageMarkerRemoteDataStore {

    fun queryMessageMarkers(
        messageIds: List<String>? = null
    ): Single<MessageMarkerQueryDto> {
        return AmityHttpClient.get(MessageMarkerApi::class).flatMap {
            it.queryMessageMarkers(
                messageIds = messageIds
            )
        }
    }
    
    fun queryMessageReadUsers(
        request: MessageReadUsersRequest
    ): Single<MessageReadUsersQueryDto> {
        return AmityHttpClient.get(MessageMarkerApi::class).flatMap {
            it.queryMessageReadUsers(
                messageId = request.messageId,
                memberships = request.getMemberships(),
                limit = request.limit,
                token = request.token
            )
        }
    }
    
    fun queryMessageDeliveredUsers(
        request: MessageDeliveredUsersRequest
    ): Single<MessageDeliveredUsersQueryDto> {
        return AmityHttpClient.get(MessageMarkerApi::class).flatMap {
            it.queryMessageDeliveredUsers(
                messageId = request.messageId,
                memberships = request.getMemberships(),
                limit = request.limit,
                token = request.token
            )
        }
    }

}