package com.amity.socialcloud.sdk.chat.data.channel.membership

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.model.chat.member.AmityChannelMember
import com.amity.socialcloud.sdk.model.chat.member.AmityMembershipType
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity
import org.joda.time.DateTime

class ChannelMembershipModelMapper : ModelMapper<ChannelMembershipEntity, AmityChannelMember>() {

    override fun map(entity: ChannelMembershipEntity): AmityChannelMember {
        return entity.run {
            AmityChannelMember(
                channelId = channelId,
                userId = userId,
                isMuted = isMuted,
                isBanned = isBanned,
                roles = roles,
                membershipType = AmityMembershipType.enumOf(membership),
                permissions = permissions,
                createdAt = createdAt ?: DateTime.now(),
                updatedAt = updatedAt ?: DateTime.now()
            )
        }
    }

}