package com.ekoapp.ekosdk.internal

import androidx.room.Entity
import androidx.room.Index
import androidx.room.PrimaryKey
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.JsonObject
import org.amity.types.ObjectId

@Entity(tableName = "file", indices = [Index("fileId")])
class EkoFileEntity : EkoObject() {

    @PrimaryKey
    var fileId: String = ObjectId.get().toHexString()
    var fileUrl: String? = null
    var filePath: String? = null
    var type: String? = null
    var accessType: String? = null
    var attributes: JsonObject? = null

    override fun getId(): String {
        return fileId
    }

    fun getFileType(): String {
        return type ?: "file"
    }

    override fun equals(obj: Any?): Boolean {
        return (super.equals(obj)
                && Objects.equal(fileId, (obj as EkoFileEntity).fileId)
                && Objects.equal(type, obj.type)
                && Objects.equal(accessType, obj.accessType)
                && Objects.equal(filePath, obj.filePath)
                && Objects.equal(fileUrl, obj.fileUrl)
                && Objects.equal(attributes, obj.attributes))
    }

    override fun hashCode(): Int {
        return Objects.hashCode(super.hashCode(), fileId, type, accessType, fileUrl, attributes)
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper): String {
        toStringHelper.add("fileId", fileId)
            .add("type", type)
            .add("accessType", accessType)
            .add("filePath", filePath)
            .add("fileUrl", fileUrl)
            .add("attributes", attributes)
        return super.internalToString(toStringHelper)
    }

}