package com.amity.socialcloud.sdk.social.domain.community.member

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.api.social.member.query.AmityCommunityMembershipSortOption
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import com.amity.socialcloud.sdk.model.social.member.AmityCommunityMember
import com.amity.socialcloud.sdk.model.social.member.AmityCommunityMembershipFilter
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipRepository
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class CommunityMembershipPagingDataUseCase {

    fun execute(
        communityId: String,
        roles: AmityRoles,
        filter: AmityCommunityMembershipFilter,
        isDeleted: Boolean?,
        sortBy: AmityCommunityMembershipSortOption
    ): Flowable<PagingData<AmityCommunityMember>> {
        return CommunityMembershipRepository().getCommunityMembershipPagingData(
            communityId = communityId,
            roles = roles,
            filters = filter,
            isDeleted = isDeleted,
            sortBy = sortBy
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { member ->
                CommunityMemberComposerUseCase().execute(member)
            }
        }
    }

}