package com.amity.socialcloud.sdk.social.data.comment

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.reaction.ReactionLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType
import com.amity.socialcloud.sdk.social.data.comment.flag.CommentFlagEntityMapper
import com.amity.socialcloud.sdk.social.data.comment.flag.CommentFlagLocalDataStore
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipEntityMapper
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentAndUserListDto
import io.reactivex.rxjava3.core.Completable

internal class CommentEventPersister : QueryPersister<EkoCommentAndUserListDto>() {

    override fun persist(dto: EkoCommentAndUserListDto): Completable {
        val commentId = dto.comments?.first()?.commentId ?: ""
        val reactor = dto.reactor
        val user = dto.users.find { it.userId == dto.reactor?.userId }
        val reactorPersistanceCompletable = if (commentId.isEmpty() || reactor == null) {
            Completable.complete()
        } else {
            when(reactor.eventName) {
                "add" -> ReactionLocalDataStore().addReaction(
                    reactionId = reactor.reactionId,
                    referenceType = AmityReactionReferenceType.COMMENT,
                    referenceId = commentId,
                    reactionName = reactor.reactionName,
                    userId = reactor.userId,
                    userDisplayName = user?.displayName ?: "unidentified",
                    createdAt = reactor.createdAt,
                    updateAt = reactor.updatedAt
                )
                "remove" -> ReactionLocalDataStore().removeReaction(
                    AmityReactionReferenceType.COMMENT,
                    commentId,
                    reactor.reactionName,
                    reactor.userId
                )
                else -> Completable.complete()
            }
        }

        return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files))
            .andThen(UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users)))
            .andThen(UserFlagLocalDataStore().saveFlags(UserFlagEntityMapper().map(dto.users)))
            .andThen(CommentLocalDataStore().saveComments(CommentEntityMapper().map(dto.commentChildren)))
            .andThen(CommentFlagLocalDataStore().saveFlags(CommentFlagEntityMapper().map(dto.commentChildren)))
            .andThen(CommentLocalDataStore().saveComments(CommentEntityMapper().map(dto.comments)))
            .andThen(CommentFlagLocalDataStore().saveFlags(CommentFlagEntityMapper().map(dto.comments)))
            .andThen(CommunityMembershipLocalDataStore().saveMemberships(CommunityMembershipEntityMapper().map(dto.communityUsers)))
            .andThen(reactorPersistanceCompletable)
    }

}