package  com.amity.socialcloud.sdk.model.core.follow

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.ekoapp.ekosdk.ReactorObject
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityFollowRelationship internal constructor(
    private val id: String,
    private val updatedAt: DateTime,
    private val sourceUser: AmityUser? = null,
    private val targetUser: AmityUser? = null,
    private val status: AmityFollowStatus = AmityFollowStatus.NONE
) : Parcelable, ReactorObject {

    fun getSourceUser(): AmityUser? {
        return sourceUser
    }

    fun getTargetUser(): AmityUser? {
        return targetUser
    }

    fun getStatus(): AmityFollowStatus {
        return status
    }

    override fun updatedAt(): DateTime {
        return updatedAt
    }

    override fun uniqueId(): String {
        return id
    }
}
