/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.comment;

import com.amity.socialcloud.sdk.common.QueryPersister;
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper;
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionLocalDataStore;
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper;
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore;
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper;
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType;
import com.amity.socialcloud.sdk.social.data.comment.CommentEntityMapper;
import com.amity.socialcloud.sdk.social.data.comment.CommentLocalDataStore;
import com.amity.socialcloud.sdk.social.data.comment.flag.CommentFlagEntityMapper;
import com.amity.socialcloud.sdk.social.data.comment.flag.CommentFlagLocalDataStore;
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipEntityMapper;
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipLocalDataStore;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentAndUserListDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoReactorDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/amity/socialcloud/sdk/social/data/comment/CommentEventPersister;", "Lcom/amity/socialcloud/sdk/common/QueryPersister;", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoCommentAndUserListDto;", "()V", "persist", "Lio/reactivex/rxjava3/core/Completable;", "dto", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nCommentEventPersister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentEventPersister.kt\ncom/amity/socialcloud/sdk/social/data/comment/CommentEventPersister\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class CommentEventPersister
extends QueryPersister<EkoCommentAndUserListDto> {
    @Override
    @NotNull
    public Completable persist(@NotNull EkoCommentAndUserListDto dto) {
        Completable completable;
        Object v2;
        Iterable iterable;
        EkoReactorDto reactor;
        List<EkoCommentDto> commentId;
        block9: {
            Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
            List<EkoCommentDto> list2 = dto.getComments();
            if (list2 == null || (list2 = (EkoCommentDto)CollectionsKt.first(list2)) == null || (list2 = ((EkoCommentDto)((Object)list2)).getCommentId()) == null) {
                list2 = "";
            }
            commentId = list2;
            reactor = dto.getReactor();
            iterable = dto.getUsers();
            for (Object t : iterable) {
                EkoUserDto it = (EkoUserDto)t;
                boolean bl = false;
                EkoReactorDto ekoReactorDto = dto.getReactor();
                if (!Intrinsics.areEqual((Object)it.getUserId(), (Object)(ekoReactorDto != null ? ekoReactorDto.getUserId() : null))) continue;
                v2 = t;
                break block9;
            }
            v2 = null;
        }
        EkoUserDto user = v2;
        if (((CharSequence)((Object)commentId)).length() == 0 || reactor == null) {
            completable = Completable.complete();
        } else {
            String string = reactor.getEventName();
            if (Intrinsics.areEqual((Object)string, (Object)"add")) {
                ReactionLocalDataStore reactionLocalDataStore = new ReactionLocalDataStore();
                String string2 = reactor.getReactionId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"reactor.reactionId");
                String string3 = reactor.getReactionName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"reactor.reactionName");
                String string4 = reactor.getUserId();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"reactor.userId");
                EkoUserDto ekoUserDto = user;
                String string5 = ekoUserDto != null ? ekoUserDto.getDisplayName() : null;
                if (string5 == null) {
                    string5 = "unidentified";
                }
                completable = reactionLocalDataStore.addReaction(string2, AmityReactionReferenceType.COMMENT, (String)((Object)commentId), string3, string4, string5, reactor.getCreatedAt(), reactor.getUpdatedAt());
            } else if (Intrinsics.areEqual((Object)string, (Object)"remove")) {
                ReactionLocalDataStore reactionLocalDataStore = new ReactionLocalDataStore();
                String string6 = reactor.getReactionName();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"reactor.reactionName");
                String string7 = reactor.getUserId();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"reactor.userId");
                completable = reactionLocalDataStore.removeReaction(AmityReactionReferenceType.COMMENT, (String)((Object)commentId), string6, string7);
            } else {
                Completable completable2 = Completable.complete();
                completable = completable2;
                Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"complete()");
            }
        }
        iterable = completable;
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"if (commentId.isEmpty() \u2026)\n            }\n        }");
        Iterable reactorPersistanceCompletable = iterable;
        Completable completable3 = new FileLocalDataStore().saveFiles(new FileEntityMapper().map(dto.getFiles())).andThen((CompletableSource)new UserLocalDataStore().saveUsers(new UserEntityMapper().map((List<? extends EkoUserDto>)dto.getUsers()))).andThen((CompletableSource)new UserFlagLocalDataStore().saveFlags(new UserFlagEntityMapper().map((List<? extends EkoUserDto>)dto.getUsers()))).andThen((CompletableSource)new CommentLocalDataStore().saveComments(new CommentEntityMapper().map(dto.getCommentChildren()))).andThen((CompletableSource)new CommentFlagLocalDataStore().saveFlags(new CommentFlagEntityMapper().map(dto.getCommentChildren()))).andThen((CompletableSource)new CommentLocalDataStore().saveComments(new CommentEntityMapper().map(dto.getComments()))).andThen((CompletableSource)new CommentFlagLocalDataStore().saveFlags(new CommentFlagEntityMapper().map(dto.getComments()))).andThen((CompletableSource)new CommunityMembershipLocalDataStore().saveMemberships(new CommunityMembershipEntityMapper().map(dto.getCommunityUsers()))).andThen((CompletableSource)reactorPersistanceCompletable);
        Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"FileLocalDataStore().sav\u2026orPersistanceCompletable)");
        return completable3;
    }
}

