package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.amity.socialcloud.sdk.socket.util.EkoGson.get
import com.google.gson.reflect.TypeToken

class StringListConverter {
	@TypeConverter
	fun stringToStringList(json: String?): List<String> {
		return get().fromJson(json, object : TypeToken<List<String?>?>() {}.type)
	}
	
	@TypeConverter
	fun stringListToString(list: List<String?>?): String {
		return get().toJson(list)
	}
}