package com.amity.socialcloud.sdk.chat.data.message

import com.amity.socialcloud.sdk.chat.data.channel.ChannelLocalDataStore
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelLocalDataStore
import com.amity.socialcloud.sdk.common.QueryPersister
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.core.Single

internal class MessageCreatedEventPersister : QueryPersister<List<MessageQueryDto>>() {

    override fun persist(list: List<MessageQueryDto>): Completable {
        return Single.fromCallable {
            mergePayload(list)
        }.flatMapCompletable {
            MessageEventPersister().persist(it)
                .andThen(updateLatestMessage(it.messages))
                .andThen(updateMessageCount(it.messages))

        }
    }

    private fun mergePayload(list: List<MessageQueryDto>) : MessageQueryDto {
        val mergedDto =  MessageQueryDto()
        list.forEach {
            mergedDto.messages = mergedDto.messages + it.messages
            mergedDto.users = mergedDto.users + it.users
            mergedDto.files = mergedDto.files + it.files
        }
        return mergedDto
    }

    private fun updateMessageCount(messages: List<EkoMessageDto>) : Completable {
        return Flowable.fromIterable(messages)
            .flatMapCompletable {
                ChannelLocalDataStore().updateDefaultSubChannelMessageCount(
                    channelId =  it.channelId,
                    subChannelId = it.subChannelId,
                    segment = it.segment
                )
            }
    }

    private fun updateLatestMessage(messages: List<EkoMessageDto>) : Completable {
        return Flowable.fromIterable(messages)
            .flatMapCompletable {
                SubChannelLocalDataStore().updateLatestMessage(
                    subChannelId = it.subChannelId,
                    messageId = it.messageId
                )
            }
    }

}